/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.collections;

import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mods.railcraft.common.util.collections.BlockKey;
import mods.railcraft.common.util.collections.ItemKey;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import org.apache.logging.log4j.Level;

public class BlockItemListParser {
    public static <T> Set<T> parseList(String list, String logMessage, ParseType type) {
        try {
            HashSet<Object> set = new HashSet<Object>();
            for (String segment : list.replaceAll("[{} ]", "").split("[,;]+")) {
                if (segment.equals("")) continue;
                set.add(type.makeKey(segment));
                Game.log(Level.DEBUG, logMessage, segment);
            }
            return set;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Invalid list while parsing config = " + list);
        }
    }

    public static <T, V> Map<T, V> parseDictionary(String list, String logMessage, ParseType type, ValueType valueType) {
        try {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (String segment : list.replaceAll("[{} ]", "").split("[,;]+")) {
                if (segment.equals("")) continue;
                String[] entry = segment.split("=");
                map.put(type.makeKey(entry[0]), valueType.parseValue(entry[1]));
                Game.log(Level.DEBUG, logMessage, segment);
            }
            return map;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Invalid map while parsing config = " + list);
        }
    }

    public static enum ValueType {
        INT{

            @Override
            public Integer parseValue(String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        FLOAT{

            @Override
            public Float parseValue(String value) {
                return Float.valueOf(value);
            }
        };


        public abstract Object parseValue(String var1);
    }

    public static enum ParseType {
        ITEM{

            @Override
            public ItemKey makeKey(String entry) throws IllegalArgumentException {
                String[] tokens = entry.split("#");
                Item item = (Item)GameData.getItemRegistry().func_82594_a(tokens[0]);
                if (item == null) {
                    throw new IllegalArgumentException("Invalid Item Name while parsing config = " + entry);
                }
                int meta = tokens.length > 1 ? Integer.valueOf(tokens[1]) : -1;
                return new ItemKey(item, meta);
            }
        }
        ,
        BLOCK{

            @Override
            public BlockKey makeKey(String entry) throws IllegalArgumentException {
                String[] tokens = entry.split("#");
                Block block = (Block)GameData.getBlockRegistry().func_82594_a(tokens[0]);
                if (block == null) {
                    throw new IllegalArgumentException("Invalid Block Name while parsing config = " + entry);
                }
                int meta = tokens.length > 1 ? Integer.valueOf(tokens[1]) : -1;
                return new BlockKey(block, meta);
            }
        };


        public abstract Object makeKey(String var1);
    }
}

