/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mods.railcraft.api.electricity.GridTools;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.electricity.IElectricMinecart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemElectricMeter
extends ItemRailcraft
implements IActivationBlockingItem {
    private static Item item;

    public static void register() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.tool.electric.meter")) {
            item = new ItemElectricMeter().func_77655_b(tag);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), "T T", "BGB", " C ", Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('G'), "paneGlassColorless", Character.valueOf('C'), "ingotCopper", Character.valueOf('T'), "ingotTin");
            LootPlugin.addLootWorkshop(new ItemStack(item), 1, 1, tag);
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public ItemElectricMeter() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77664_n();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Entity entity = event.target;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemElectricMeter) {
            player.func_71038_i();
        }
        if (Game.isNotHost(player.field_70170_p)) {
            return;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemElectricMeter) {
            try {
                IElectricMinecart cart;
                IElectricMinecart.ChargeHandler ch;
                if (entity instanceof IElectricMinecart && (ch = (cart = (IElectricMinecart)entity).getChargeHandler()) != null) {
                    ChatPlugin.sendLocalizedChat(player, "railcraft.gui.electric.meter.charge", ch.getCharge(), ch.getDraw(), ch.getLosses());
                    event.setCanceled(true);
                }
            }
            catch (Throwable er) {
                Game.logErrorAPI("Railcraft", er, IElectricMinecart.class);
                ChatPlugin.sendLocalizedChatFromServer(player, "chat.railcraft.api.error", new Object[0]);
            }
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (Game.isNotHost(world)) {
            return false;
        }
        boolean returnValue = false;
        try {
            IElectricGrid.ChargeHandler ch;
            IElectricGrid gridObject = GridTools.getGridObjectAt((IBlockAccess)world, x, y, z);
            if (gridObject != null && (ch = gridObject.getChargeHandler()) != null) {
                ChatPlugin.sendLocalizedChat(player, "railcraft.gui.electric.meter.charge", ch.getCharge(), ch.getDraw(), ch.getLosses());
                returnValue = true;
            }
        }
        catch (Throwable er) {
            Game.logErrorAPI("Railcraft", er, IElectricGrid.class);
            ChatPlugin.sendLocalizedChatFromServer(player, "chat.railcraft.api.error", new Object[0]);
        }
        return returnValue;
    }
}

