/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.Set;
import mods.railcraft.api.carts.IFluidCart;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.api.carts.ITrainTransferHelper;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TrainTransferHelper
implements ITrainTransferHelper {
    public static final ITrainTransferHelper INSTANCE = new TrainTransferHelper();
    private static final int NUM_SLOTS = 8;
    private static final int TANK_CAPACITY = 8000;

    private TrainTransferHelper() {
    }

    @Override
    public ItemStack pushStack(EntityMinecart requester, ItemStack stack) {
        Iterable<EntityMinecart> carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_A);
        stack = this._pushStack(requester, carts, stack);
        if (stack == null) {
            return null;
        }
        if (LinkageManager.instance().hasLink(requester, LinkageManager.LinkType.LINK_B)) {
            carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_B);
            stack = this._pushStack(requester, carts, stack);
        }
        return stack;
    }

    private ItemStack _pushStack(EntityMinecart requester, Iterable<EntityMinecart> carts, ItemStack stack) {
        for (EntityMinecart cart : carts) {
            if (this.canAcceptPushedItem(requester, cart, stack)) {
                stack = InvTools.moveItemStack(stack, (IInventory)cart);
            }
            if (stack != null && this.canPassItemRequests(cart)) continue;
            break;
        }
        return stack;
    }

    @Override
    public ItemStack pullStack(EntityMinecart requester, IStackFilter filter) {
        Iterable<EntityMinecart> carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_A);
        ItemStack stack = this._pullStack(requester, carts, filter);
        if (stack != null) {
            return stack;
        }
        carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_B);
        return this._pullStack(requester, carts, filter);
    }

    private ItemStack _pullStack(EntityMinecart requester, Iterable<EntityMinecart> carts, IStackFilter filter) {
        for (EntityMinecart cart : carts) {
            if (cart instanceof IInventory) {
                Set<ItemStack> items = InvTools.findMatchingItems((IInventory)cart, filter);
                for (ItemStack stack : items) {
                    ItemStack removed;
                    if (stack == null || !this.canProvidePulledItem(requester, cart, stack) || (removed = InvTools.removeOneItem((IInventory)cart, stack)) == null) continue;
                    return removed;
                }
            }
            if (this.canPassItemRequests(cart)) continue;
            break;
        }
        return null;
    }

    private boolean canAcceptPushedItem(EntityMinecart requester, EntityMinecart cart, ItemStack stack) {
        if (!(cart instanceof IInventory)) {
            return false;
        }
        if (cart instanceof IItemCart) {
            return ((IItemCart)cart).canAcceptPushedItem(requester, stack);
        }
        return true;
    }

    private boolean canProvidePulledItem(EntityMinecart requester, EntityMinecart cart, ItemStack stack) {
        if (!(cart instanceof IInventory)) {
            return false;
        }
        if (cart instanceof IItemCart) {
            return ((IItemCart)cart).canProvidePulledItem(requester, stack);
        }
        return true;
    }

    private boolean canPassItemRequests(EntityMinecart cart) {
        if (cart instanceof IItemCart) {
            return ((IItemCart)cart).canPassItemRequests();
        }
        if (cart instanceof IInventory) {
            return ((IInventory)cart).func_70302_i_() >= 8;
        }
        return false;
    }

    @Override
    public FluidStack pushFluid(EntityMinecart requester, FluidStack fluidStack) {
        Iterable<EntityMinecart> carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_A);
        fluidStack = this._pushFluid(requester, carts, fluidStack);
        if (fluidStack == null) {
            return null;
        }
        if (LinkageManager.instance().hasLink(requester, LinkageManager.LinkType.LINK_B)) {
            carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_B);
            fluidStack = this._pushFluid(requester, carts, fluidStack);
        }
        return fluidStack;
    }

    private FluidStack _pushFluid(EntityMinecart requester, Iterable<EntityMinecart> carts, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        for (EntityMinecart cart : carts) {
            if (this.canAcceptPushedFluid(requester, cart, fluidStack.getFluid())) {
                fluidStack.amount -= ((IFluidHandler)cart).fill(ForgeDirection.UP, fluidStack, true);
            }
            if (fluidStack.amount > 0 && this.canPassFluidRequests(cart, fluidStack.getFluid())) continue;
            break;
        }
        if (fluidStack.amount <= 0) {
            return null;
        }
        return fluidStack;
    }

    @Override
    public FluidStack pullFluid(EntityMinecart requester, FluidStack fluidStack) {
        Iterable<EntityMinecart> carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_A);
        FluidStack pulled = this._pullFluid(requester, carts, fluidStack);
        if (pulled != null) {
            return pulled;
        }
        carts = LinkageManager.instance().getLinkedCarts(requester, LinkageManager.LinkType.LINK_B);
        return this._pullFluid(requester, carts, fluidStack);
    }

    private FluidStack _pullFluid(EntityMinecart requester, Iterable<EntityMinecart> carts, FluidStack fluidStack) {
        for (EntityMinecart cart : carts) {
            FluidStack drained;
            IFluidHandler fluidHandler;
            if (this.canProvidePulledFluid(requester, cart, fluidStack.getFluid()) && (fluidHandler = (IFluidHandler)cart).canDrain(ForgeDirection.DOWN, fluidStack.getFluid()) && (drained = fluidHandler.drain(ForgeDirection.DOWN, fluidStack, true)) != null) {
                return drained;
            }
            if (this.canPassFluidRequests(cart, fluidStack.getFluid())) continue;
            break;
        }
        return null;
    }

    private boolean canAcceptPushedFluid(EntityMinecart requester, EntityMinecart cart, Fluid fluid) {
        if (!(cart instanceof IFluidHandler)) {
            return false;
        }
        if (cart instanceof IFluidCart) {
            return ((IFluidCart)cart).canAcceptPushedFluid(requester, fluid);
        }
        return ((IFluidHandler)cart).canFill(ForgeDirection.UP, fluid);
    }

    private boolean canProvidePulledFluid(EntityMinecart requester, EntityMinecart cart, Fluid fluid) {
        if (!(cart instanceof IFluidHandler)) {
            return false;
        }
        if (cart instanceof IFluidCart) {
            return ((IFluidCart)cart).canProvidePulledFluid(requester, fluid);
        }
        return ((IFluidHandler)cart).canDrain(ForgeDirection.DOWN, fluid);
    }

    private boolean canPassFluidRequests(EntityMinecart cart, Fluid fluid) {
        if (cart instanceof IFluidCart) {
            return ((IFluidCart)cart).canPassFluidRequests(fluid);
        }
        return cart instanceof IFluidHandler && this.hasMatchingTank((IFluidHandler)cart, fluid);
    }

    private boolean hasMatchingTank(IFluidHandler handler, Fluid fluid) {
        FluidTankInfo[] tankInfo;
        for (FluidTankInfo info : tankInfo = handler.getTankInfo(ForgeDirection.UP)) {
            if (info.capacity < 8000 || info.fluid != null && info.fluid.amount != 0 && info.fluid.getFluid() != fluid) continue;
            return true;
        }
        return false;
    }
}

