/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityLocomotiveCreative
extends EntityLocomotive
implements ISidedInventory {
    private static final int SLOT_TICKET = 0;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 1);
    private final IInventory invTicket = new InventoryMapper((IInventory)this, 0, 2, false);

    public EntityLocomotiveCreative(World world) {
        super(world);
    }

    public EntityLocomotiveCreative(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.LOCO_CREATIVE;
    }

    @Override
    public String getWhistle() {
        return "railcraft:locomotive.electric.whistle";
    }

    @Override
    protected void openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOCO_CREATIVE, player, this.field_70170_p, (Entity)this);
    }

    @Override
    public void setMode(EntityLocomotive.LocoMode mode) {
        if (mode == EntityLocomotive.LocoMode.IDLE) {
            mode = EntityLocomotive.LocoMode.SHUTDOWN;
        }
        super.setMode(mode);
    }

    @Override
    protected int getIdleFuelUse() {
        return 0;
    }

    @Override
    public int getMoreGoJuice() {
        return 100;
    }

    @Override
    public LocomotiveRenderType getRenderType() {
        return LocomotiveRenderType.ELECTRIC;
    }

    @Override
    protected ItemStack getCartItemBase() {
        return EnumCart.LOCO_CREATIVE.getCartItem();
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 0.92f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected IInventory getTicketInventory() {
        return this.invTicket;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return ItemTicket.FILTER.matches(stack);
            }
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
    }

    @Override
    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
    }
}

