/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackCustomPlaced;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemTrack
extends ItemBlock
implements ITrackItem {
    public ItemTrack(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("railcraft.track");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        TrackSpec trackSpec = this.getTrackSpec(stack);
        if (trackSpec == null) {
            return Blocks.field_150448_aq.func_149691_a(0, 0);
        }
        return trackSpec.getItemIcon();
    }

    public TrackSpec getTrackSpec(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == this) {
            NBTTagCompound nbt = InvTools.getItemData(stack);
            if (nbt.func_74764_b("track")) {
                return TrackRegistry.getTrackSpec(nbt.func_74779_i("track"));
            }
            return TrackRegistry.getTrackSpec(-1);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    public int func_77647_b(int i) {
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        return "tile." + this.getTrackSpec(stack).getTrackTag().replace(':', '.');
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        try {
            TrackSpec spec = this.getTrackSpec(stack);
            List<String> tips = spec.getItemToolTip();
            if (tips != null) {
                list.addAll(tips);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error, TrackSpec.class);
        }
    }

    @Override
    public Block getPlacedBlock() {
        return RailcraftBlocks.getBlockTrack();
    }

    @Override
    public boolean isPlacedTileEntity(ItemStack stack, TileEntity tile) {
        TileTrack track;
        return tile instanceof TileTrack && (track = (TileTrack)tile).getTrackInstance().getTrackSpec() == this.getTrackSpec(stack);
    }

    @Override
    public boolean placeTrack(ItemStack stack, World world, int i, int j, int k) {
        return this.placeTrack(stack, world, i, j, k, 1);
    }

    private boolean placeTrack(ItemStack stack, World world, int i, int j, int k, int side) {
        Block blockTrack = RailcraftBlocks.getBlockTrack();
        if (blockTrack == null) {
            return false;
        }
        if (j >= world.func_72800_K() - 1) {
            return false;
        }
        if (stack == null || !(stack.func_77973_b() instanceof ItemTrack)) {
            return false;
        }
        TrackSpec spec = this.getTrackSpec(stack);
        ITrackInstance track = spec.createInstanceFromSpec();
        boolean canPlace = world.func_147472_a(blockTrack, i, j, k, true, side, null, stack);
        canPlace = track instanceof ITrackCustomPlaced ? (canPlace &= ((ITrackCustomPlaced)track).canPlaceRailAt(world, i, j, k)) : (canPlace &= world.isSideSolid(i, j - 1, k, ForgeDirection.UP));
        if (canPlace) {
            boolean placed = world.func_147449_b(i, j, k, blockTrack);
            if (placed) {
                if (world.func_147439_a(i, j, k) == blockTrack) {
                    TileTrack tile = TrackFactory.makeTrackTile(track);
                    world.func_147455_a(i, j, k, (TileEntity)tile);
                    blockTrack.func_149714_e(world, i, j, k, 0);
                    world.func_147471_g(i, j, k);
                }
                world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), blockTrack.field_149762_H.func_150498_e(), (blockTrack.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockTrack.field_149762_H.func_150494_d() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (stack.field_77994_a <= 0) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (player != null && !player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        boolean success = this.placeTrack(stack, world, x, y, z, side);
        if (success) {
            Block blockTrack = RailcraftBlocks.getBlockTrack();
            if (player != null) {
                blockTrack.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            }
            --stack.field_77994_a;
        }
        return success;
    }
}

