/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.sounds;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.sounds.IBlockSoundProvider;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;

public class RCSoundHandler {
    public static final RCSoundHandler INSTANCE = new RCSoundHandler();

    private RCSoundHandler() {
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent17 event) {
        World world;
        String soundName = event.name;
        if (soundName != null && event.sound instanceof PositionedSoundRecord && soundName.contains("railcraft") && (world = Railcraft.getProxy().getClientWorld()) != null) {
            int iz;
            int iy;
            float x = event.sound.func_147649_g();
            float y = event.sound.func_147654_h();
            float z = event.sound.func_147651_i();
            int ix = MathHelper.func_76141_d((float)x);
            Block.SoundType sound = this.getBlockSound(world, ix, iy = MathHelper.func_76141_d((float)y), iz = MathHelper.func_76141_d((float)z));
            if (sound == null) {
                if (soundName.contains("place")) {
                    event.manager.func_148599_a(event.sound, 3);
                } else if (soundName.contains("step")) {
                    sound = this.getBlockSound(world, ix, iy - 1, iz);
                }
            }
            if (sound != null) {
                String newName = sound.func_150498_e();
                if (soundName.contains("dig")) {
                    newName = sound.func_150495_a();
                } else if (soundName.contains("place")) {
                    newName = sound.func_150496_b();
                }
                event.result = new PositionedSoundRecord(new ResourceLocation(newName), event.sound.func_147653_e(), event.sound.func_147655_f() * sound.func_150494_d(), x, y, z);
            }
        }
    }

    private Block.SoundType getBlockSound(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IBlockSoundProvider) {
            return ((IBlockSoundProvider)block).getSound(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        return SoundRegistry.getSound(block, meta);
    }
}

