/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.EnumSet;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackTile;
import mods.railcraft.common.blocks.tracks.TrackSuspended;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenancePatternBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCartTrackRelayer
extends CartMaintenancePatternBase {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_EXIST = 0;
    private static final int SLOT_REPLACE = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 1);

    public EntityCartTrackRelayer(World world) {
        super(world);
    }

    public EntityCartTrackRelayer(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TRACK_RELAYER;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        Block block;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (TrackTools.isRailBlockAt((IBlockAccess)this.field_70170_p, i, (j = MathHelper.func_76128_c((double)this.field_70163_u)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            --j;
        }
        if (TrackTools.isRailBlock(block = this.field_70170_p.func_147439_a(i, j, k))) {
            ItemStack trackExist = this.patternInv.func_70301_a(0);
            ItemStack trackStock = this.func_70301_a(0);
            boolean nextToSuspended = false;
            for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH)) {
                ITrackTile track;
                TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_70170_p, i, j, k, side);
                if (!(tile instanceof ITrackTile) || !((track = (ITrackTile)tile).getTrackInstance() instanceof TrackSuspended)) continue;
                nextToSuspended = true;
                break;
            }
            if (nextToSuspended) {
                return;
            }
            if (trackExist != null && trackStock != null) {
                int meta;
                if (trackExist.func_77973_b() instanceof ITrackItem) {
                    int meta2;
                    TileEntity tile;
                    ITrackItem trackItem = (ITrackItem)trackExist.func_77973_b();
                    if (trackItem.getPlacedBlock() == block && trackItem.isPlacedTileEntity(trackExist, tile = this.field_70170_p.func_147438_o(i, j, k)) && (meta2 = this.removeOldTrack(i, j, k, block)) != -1) {
                        this.placeNewTrack(i, j, k, 0, meta2);
                    }
                } else if (InvTools.isStackEqualToBlock(trackExist, block) && (meta = this.removeOldTrack(i, j, k, block)) != -1) {
                    this.placeNewTrack(i, j, k, 0, meta);
                }
            }
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_TRACK_RELAYER, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Override
    public String func_145825_b() {
        return LocalizationPlugin.translate(EnumCart.TRACK_RELAYER.getTag());
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternInv.func_70301_a(1);
        return InvTools.isItemEqual(stack, trackReplace);
    }
}

