/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.anvil.BlockRCAnvil;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.commands.RootCommand;
import mods.railcraft.common.core.CommonProxy;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.RailcraftFluids;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.firestone.BlockFirestoneRecharge;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.craftguide.CraftGuidePlugin;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.BlinkTick;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Level;

@Mod(modid="Railcraft", name="Railcraft", version="9.14.0", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.4.1614,);after:BuildCraft|Core[6.1.7,);after:BuildCraft|Energy;after:BuildCraft|Builders;after:BuildCraft|Factory;after:BuildCraftAPI|statements[1.0,);after:BuildCraftAPI|transport[1.0,);after:Forestry[3,);after:Thaumcraft;after:IC2@[2.2,)")
public final class Railcraft {
    public static final String MOD_ID = "Railcraft";
    public static final String VERSION = "9.14.0";
    public static final String MC_VERSION = "[1.7.10,1.8)";
    public static final RootCommand rootCommand = new RootCommand();
    @Mod.Instance(value="Railcraft")
    public static Railcraft instance;
    @SidedProxy(clientSide="mods.railcraft.client.core.ClientProxy", serverSide="mods.railcraft.common.core.CommonProxy")
    public static CommonProxy proxy;
    private File configFolder;

    public static CommonProxy getProxy() {
        return proxy;
    }

    public static Railcraft getMod() {
        return instance;
    }

    public static String getModId() {
        return MOD_ID;
    }

    public static String getVersion() {
        return VERSION;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage mess : event.getMessages()) {
            NBTTagCompound nbt;
            String[] tokens;
            if (mess.key.equals("ballast")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                String blockName = tokens[0];
                Integer metadata = Ints.tryParse((String)tokens[1]);
                if (blockName == null || metadata == null) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                BallastRegistry.registerBallast(Block.func_149684_b((String)blockName), metadata);
                Game.log(Level.DEBUG, String.format("Mod %s registered %s as a valid ballast", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (mess.key.equals("boiler-fuel-liquid")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                Fluid fluid = FluidRegistry.getFluid((String)tokens[0]);
                Integer fuel = Ints.tryParse((String)tokens[1]);
                if (fluid == null || fuel == null) {
                    Game.log(Level.WARN, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                FuelManager.addBoilerFuel(fluid, fuel);
                Game.log(Level.DEBUG, String.format("Mod %s registered %s as a valid liquid Boiler fuel", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (mess.key.equals("rock-crusher") && !Game.isGTNH) {
                nbt = mess.getNBTValue();
                ItemStack input = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("input"));
                IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(input, nbt.func_74767_n("matchMeta"), nbt.func_74767_n("matchNBT"));
                for (int i = 0; i < 9; ++i) {
                    if (!nbt.func_74764_b("output" + i)) continue;
                    NBTTagCompound outputNBT = nbt.func_74775_l("output" + i);
                    recipe.addOutput(ItemStack.func_77949_a((NBTTagCompound)outputNBT), outputNBT.func_74760_g("chance"));
                }
                continue;
            }
            if (!mess.key.equals("high-speed-explosion-excluded-entities")) continue;
            nbt = mess.getNBTValue();
            if (nbt.func_74764_b("entities")) {
                String entities = nbt.func_74779_i("entities");
                Iterable split = splitter.split((CharSequence)entities);
                RailcraftConfig.excludedAllEntityFromHighSpeedExplosions(split);
                continue;
            }
            Game.log(Level.WARN, "Mod %s attempted to exclude an entity from H.S. explosions, but failed: %s", mess.getSender(), nbt);
        }
    }

    @Mod.EventHandler
    public void fingerprintError(FMLFingerprintViolationEvent event) {
        if (Game.isObfuscated()) {
            Game.logErrorFingerprint(MOD_ID);
            throw new RuntimeException("Invalid Fingerprint");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Game.isGTNH = Loader.isModLoaded((String)"dreamcraft");
        this.configFolder = new File(event.getModConfigurationDirectory(), "railcraft");
        RailcraftConfig.preInit();
        PacketHandler.init();
        StackFilter.initialize();
        ModuleManager.preInit();
        proxy.preInitClient();
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.railcraft.info/donate/");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModuleManager.init();
        FMLCommonHandler.instance().bus().register((Object)new BlinkTick());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleManager.postInit();
        proxy.initClient();
        CraftGuidePlugin.init();
        RailcraftConfig.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandHandler commandManager = (CommandHandler)event.getServer().func_71187_D();
        commandManager.func_71560_a((ICommand)rootCommand);
    }

    @Mod.EventHandler
    public void serverCleanUp(FMLServerStoppingEvent event) {
        LinkageManager.reset();
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Block block;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                block = GameRegistry.findBlock((String)Railcraft.getModId(), (String)MiscTools.cleanTag(mapping.name));
                if (block != null) {
                    this.remap(block, mapping);
                    continue;
                }
                if (mapping.name.equals("Railcraft:tile.railcraft.block.fluid.creosote") && RailcraftFluids.CREOSOTE.getBlock() != null) {
                    this.remap(RailcraftFluids.CREOSOTE.getBlock(), mapping);
                    continue;
                }
                if (mapping.name.equals("Railcraft:tile.railcraft.block.fluid.steam") && RailcraftFluids.STEAM.getBlock() != null) {
                    this.remap(RailcraftFluids.STEAM.getBlock(), mapping);
                    continue;
                }
                if (mapping.name.equals("Railcraft:tile.block.firestone.recharge") && BlockFirestoneRecharge.getBlock() != null) {
                    this.remap(BlockFirestoneRecharge.getBlock(), mapping);
                    continue;
                }
                if (mapping.name.equals("Railcraft:tile.railcraft.block.anvil") && BlockRCAnvil.getBlock() != null) {
                    this.remap(BlockRCAnvil.getBlock(), mapping);
                    continue;
                }
                if (mapping.name.equals("Railcraft:tile.railcraft.hidden")) {
                    mapping.ignore();
                    continue;
                }
                if (!mapping.name.equals("Railcraft:tile.railcraft.stonelamp")) continue;
                this.remap(BlockLantern.getBlockStone(), mapping);
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            block = GameRegistry.findBlock((String)Railcraft.getModId(), (String)MiscTools.cleanTag(mapping.name));
            if (block != null) {
                this.remap(Item.func_150898_a((Block)block), mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tool.mag.glass") && ItemMagnifyingGlass.item != null) {
                this.remap(ItemMagnifyingGlass.item, mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tile.railcraft.block.fluid.creosote") && RailcraftFluids.CREOSOTE.getBlock() != null) {
                this.remap(Item.func_150898_a((Block)RailcraftFluids.CREOSOTE.getBlock()), mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tile.railcraft.block.fluid.steam") && RailcraftFluids.STEAM.getBlock() != null) {
                this.remap(Item.func_150898_a((Block)RailcraftFluids.STEAM.getBlock()), mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tile.block.firestone.recharge") && BlockFirestoneRecharge.getBlock() != null) {
                this.remap(Item.func_150898_a((Block)BlockFirestoneRecharge.getBlock()), mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tile.railcraft.block.anvil") && BlockRCAnvil.getBlock() != null) {
                this.remap(Item.func_150898_a((Block)BlockRCAnvil.getBlock()), mapping);
                continue;
            }
            if (mapping.name.equals("Railcraft:tile.railcraft.hidden")) {
                mapping.ignore();
                continue;
            }
            if (!mapping.name.equals("Railcraft:tile.railcraft.stonelamp")) continue;
            this.remap(Item.func_150898_a((Block)BlockLantern.getBlockStone()), mapping);
        }
    }

    private void remap(Block block, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(block);
        Game.log(Level.WARN, "Remapping block " + mapping.name + " to " + Railcraft.getModId() + ":" + MiscTools.cleanTag(block.func_149739_a()), new Object[0]);
    }

    private void remap(Item item, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(item);
        Game.log(Level.WARN, "Remapping item " + mapping.name + " to " + Railcraft.getModId() + ":" + MiscTools.cleanTag(item.func_77658_a()), new Object[0]);
    }
}

