/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.wall;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallBeta;
import mods.railcraft.common.blocks.aesthetics.wall.ItemWall;
import mods.railcraft.common.blocks.aesthetics.wall.WallInfo;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxy;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxyApha;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxyBeta;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRailcraftWall
extends BlockWall {
    private static BlockRailcraftWall alpha;
    private static BlockRailcraftWall beta;
    public static int currentRenderPass;
    private final int renderId;
    public final WallProxy proxy;
    private final boolean alphaBlend;

    public static BlockRailcraftWall getBlockAlpha() {
        return alpha;
    }

    public static BlockRailcraftWall getBlockBeta() {
        return beta;
    }

    public static void registerBlocks() {
        int renderId;
        if (alpha == null && RailcraftConfig.isBlockEnabled("wall.alpha")) {
            renderId = Railcraft.getProxy().getRenderId();
            alpha = new BlockRailcraftWall(renderId, true, new WallProxyApha());
            alpha.func_149663_c("railcraft.wall.alpha");
            RailcraftRegistry.register((Block)alpha, ItemWall.class);
            for (Enum enum_ : EnumWallAlpha.VALUES) {
                switch (1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha[enum_.ordinal()]) {
                    case 1: {
                        HarvestPlugin.setHarvestLevel((Block)alpha, enum_.ordinal(), "shovel", 0);
                        break;
                    }
                    case 2: {
                        HarvestPlugin.setHarvestLevel((Block)alpha, enum_.ordinal(), "pickaxe", 3);
                        break;
                    }
                    default: {
                        HarvestPlugin.setHarvestLevel((Block)alpha, enum_.ordinal(), "pickaxe", 2);
                    }
                }
                RailcraftRegistry.register(((EnumWallAlpha)enum_).getItem());
                if (enum_ == EnumWallAlpha.SNOW && enum_ == EnumWallAlpha.ICE) continue;
                ForestryPlugin.addBackpackItem("builder", ((EnumWallAlpha)enum_).getItem());
            }
        }
        if (beta == null && RailcraftConfig.isBlockEnabled("wall.beta")) {
            renderId = Railcraft.getProxy().getRenderId();
            beta = new BlockRailcraftWall(renderId, false, new WallProxyBeta());
            beta.func_149663_c("railcraft.wall.beta");
            RailcraftRegistry.register((Block)beta, ItemWall.class);
            for (Enum enum_ : EnumWallBeta.VALUES) {
                switch (1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallBeta[enum_.ordinal()]) {
                    default: 
                }
                HarvestPlugin.setHarvestLevel((Block)beta, enum_.ordinal(), "pickaxe", 2);
                RailcraftRegistry.register(((EnumWallBeta)enum_).getItem());
                ForestryPlugin.addBackpackItem("builder", ((EnumWallBeta)enum_).getItem());
            }
        }
    }

    public static void initialize() {
        EnumWallAlpha.initialize();
        EnumWallBeta.initialize();
    }

    public BlockRailcraftWall(int renderId, boolean alphaBlend, WallProxy proxy) {
        super(Blocks.field_150417_aV);
        this.renderId = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? 32 : renderId;
        this.alphaBlend = alphaBlend;
        this.proxy = proxy;
        this.func_149672_a(RailcraftSound.getInstance());
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
    }

    public IIcon func_149691_a(int side, int meta) {
        WallInfo wall = this.proxy.fromMeta(meta);
        Block source = wall.getSource();
        if (source == null) {
            return Blocks.field_150347_e.func_149691_a(side, 0);
        }
        return source.func_149691_a(side, wall.getSourceMeta());
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public int func_149701_w() {
        return this.alphaBlend ? 1 : 0;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        if (!this.alphaBlend) {
            return this.func_149701_w() == pass;
        }
        return pass == 0 || pass == 1;
    }

    public boolean func_150091_e(IBlockAccess world, int x, int y, int z) {
        Block block = WorldPlugin.getBlock(world, x, y, z);
        if (block instanceof BlockRailcraftWall) {
            return true;
        }
        if (block != this && block != Blocks.field_150396_be) {
            return block != null && block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false;
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (WallInfo wallInfo : this.proxy.getCreativeList()) {
            if (!wallInfo.isEnabled()) continue;
            list.add(wallInfo.getItem());
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        WallInfo wall = this.proxy.fromMeta(meta);
        return wall.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        WallInfo wall = this.proxy.fromMeta(meta);
        return wall.getExplosionResistance(entity);
    }
}

