/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.client.gui.GuiRoutingTable;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.NBTPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemRoutingTable
extends ItemRailcraft
implements IEditableItem {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null || item == null) {
                return false;
            }
            return stack.func_77973_b() == item;
        }
    };
    public static final int LINE_LENGTH = 37;
    public static final int LINES_PER_PAGE = 13;
    public static ItemRoutingTable item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.routing.table")) {
            item = new ItemRoutingTable();
            item.func_77655_b(tag);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapelessRecipe(new ItemStack((Item)item), Items.field_151099_bA, "dyeBlue");
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    @Override
    public boolean validateNBT(NBTTagCompound nbt) {
        return ItemRoutingTable.validBookTagContents(nbt);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemRoutingTable.validBookTagPages(nbt)) {
            return false;
        }
        if (nbt.func_74764_b("title")) {
            String s = nbt.func_74779_i("title");
            return s != null && s.length() <= 16 ? nbt.func_74764_b("author") : false;
        }
        return true;
    }

    public static boolean validBookTagPages(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74764_b("pages")) {
            return false;
        }
        NBTPlugin.NBTList pages = NBTPlugin.getNBTList(nbt, "pages", NBTPlugin.EnumNBTType.LIST);
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            NBTTagList pageNBT = (NBTTagList)iterator.next();
            NBTPlugin.NBTList page = new NBTPlugin.NBTList(pageNBT);
            if (page.size() > 13) {
                return false;
            }
            Iterator iterator2 = page.iterator();
            while (iterator2.hasNext()) {
                NBTTagString line = (NBTTagString)iterator2.next();
                if (line.func_150285_a_() == null) {
                    return false;
                }
                if (line.func_150285_a_().length() <= 37) continue;
                return false;
            }
        }
        return true;
    }

    public static RoutingLogic getLogic(ItemStack routingTable) {
        LinkedList<String> routingData = ItemRoutingTable.getContents(routingTable);
        return RoutingLogic.buildLogic(routingData);
    }

    public static LinkedList<String> getContents(ItemStack routingTable) {
        if (routingTable == null || routingTable.func_77973_b() != item) {
            return null;
        }
        NBTTagCompound nbt = routingTable.func_77978_p();
        if (nbt == null) {
            return null;
        }
        LinkedList<String> contents = new LinkedList<String>();
        NBTPlugin.NBTList pages = NBTPlugin.getNBTList(nbt, "pages", NBTPlugin.EnumNBTType.LIST);
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            NBTTagList page = (NBTTagList)iterator.next();
            NBTPlugin.NBTList lines = new NBTPlugin.NBTList(page);
            Iterator iterator2 = lines.iterator();
            while (iterator2.hasNext()) {
                NBTTagString line = (NBTTagString)iterator2.next();
                if (line.func_150285_a_() == null) continue;
                contents.add(line.func_150285_a_());
            }
        }
        return contents;
    }

    public static LinkedList<LinkedList<String>> getPages(ItemStack routingTable) {
        if (routingTable == null || routingTable.func_77973_b() != item) {
            return null;
        }
        NBTTagCompound nbt = routingTable.func_77978_p();
        if (nbt == null) {
            return null;
        }
        NBTPlugin.NBTList pagesList = NBTPlugin.getNBTList(nbt, "pages", NBTPlugin.EnumNBTType.LIST);
        LinkedList<LinkedList<String>> contents = new LinkedList<LinkedList<String>>();
        Iterator iterator = pagesList.iterator();
        while (iterator.hasNext()) {
            NBTTagList pageNBT = (NBTTagList)iterator.next();
            NBTPlugin.NBTList pageList = new NBTPlugin.NBTList(pageNBT);
            LinkedList<String> page = new LinkedList<String>();
            contents.add(page);
            Iterator iterator2 = pageList.iterator();
            while (iterator2.hasNext()) {
                NBTTagString line = (NBTTagString)iterator2.next();
                if (line.func_150285_a_() == null) continue;
                page.add(line.func_150285_a_());
            }
        }
        return contents;
    }

    public static void setPages(ItemStack routingTable, LinkedList<LinkedList<String>> pages) {
        ItemRoutingTable.cleanEmptyPages(pages);
        NBTTagList data = new NBTTagList();
        ListIterator pageIt = pages.listIterator();
        while (pageIt.hasNext()) {
            List page = (List)pageIt.next();
            NBTTagList pageNBT = new NBTTagList();
            data.func_74742_a((NBTBase)pageNBT);
            ListIterator lineIt = page.listIterator();
            while (lineIt.hasNext()) {
                String line = (String)lineIt.next();
                pageNBT.func_74742_a((NBTBase)new NBTTagString(line));
            }
        }
        NBTTagCompound nbt = InvTools.getItemData(routingTable);
        nbt.func_74782_a("pages", (NBTBase)data);
    }

    private static void cleanEmptyPages(LinkedList<LinkedList<String>> pages) {
        Iterator<LinkedList<String>> pageIt = pages.descendingIterator();
        while (pageIt.hasNext()) {
            List page = pageIt.next();
            for (String line : page) {
                if (line.equals("")) continue;
                return;
            }
            pageIt.remove();
        }
    }

    public static String getOwner(ItemStack ticket) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("author");
    }

    public ItemRoutingTable() {
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:routing.table");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagString title;
        if (stack.func_77942_o() && (title = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("title")) != null) {
            return super.func_77653_i(stack) + " - " + title.toString();
        }
        return super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        NBTTagCompound nbt;
        NBTTagString author;
        if (stack.func_77942_o() && (author = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("author")) != null) {
            list.add(EnumChatFormatting.GRAY + String.format(LocalizationPlugin.translate("railcraft.gui.routing.table.editor"), author.func_150285_a_()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Game.isNotHost(world)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRoutingTable(player, stack));
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean canPlayerEdit(EntityPlayer player, ItemStack stack) {
        return true;
    }
}

