/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cofh.api.energy.EnergyStorage;
import mods.railcraft.common.blocks.machine.alpha.TileRollingMachine;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotUnshiftable;
import mods.railcraft.common.gui.slots.SlotUntouchable;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerRollingMachine
extends RailcraftContainer {
    private final TileRollingMachine tile;
    private final InventoryCrafting craftMatrix;
    private final IInventory craftResult;
    private int lastProgress;
    private ItemStack prevOutput;
    private final RFEnergyIndicator energyIndicator;

    public ContainerRollingMachine(InventoryPlayer inventoryplayer, final TileRollingMachine tile) {
        super((IInventory)tile);
        this.tile = tile;
        this.craftMatrix = tile.getCraftMatrix();
        this.craftResult = new InventoryCraftResult(){

            public void func_70299_a(int slot, ItemStack stack) {
                super.func_70299_a(slot, stack);
                if (stack != null && Game.isNotHost(tile.func_145831_w())) {
                    InvTools.addItemToolTip(stack, LocalizationPlugin.translate("railcraft.gui.rolling.machine.tip.craft"));
                }
            }
        };
        this.energyIndicator = new RFEnergyIndicator(tile);
        this.addWidget(new IndicatorWidget(this.energyIndicator, 157, 19, 176, 12, 6, 48));
        this.addSlot(new SlotRollingMachine(this.craftResult, 0, 93, 27));
        this.addSlot(new SlotOutput((IInventory)tile, 0, 124, 35));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.addSlot(new SlotUnshiftable((IInventory)this.craftMatrix, k1 + l * 3, 30 + k1 * 18, 17 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int l1 = 0; l1 < 9; ++l1) {
                this.addSlot(new Slot((IInventory)inventoryplayer, l1 + i1 * 9 + 9, 8 + l1 * 18, 84 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j1, 8 + j1 * 18, 142));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a((Container)this, 0, this.tile.getProgress());
        EnergyStorage storage = this.tile.getEnergyStorage();
        if (storage != null) {
            icrafting.func_71112_a((Container)this, 1, storage.getEnergyStored());
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        EnergyStorage storage = this.tile.getEnergyStorage();
        for (Object crafter : this.field_75149_d) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastProgress != this.tile.getProgress()) {
                icrafting.func_71112_a((Container)this, 0, this.tile.getProgress());
            }
            if (storage == null) continue;
            icrafting.func_71112_a((Container)this, 2, storage.getEnergyStored());
        }
        ItemStack output = this.tile.func_70301_a(0);
        if (!InvTools.isItemEqualStrict(output, this.prevOutput)) {
            this.func_75130_a((IInventory)this.craftMatrix);
            this.prevOutput = output != null ? output.func_77946_l() : null;
        }
        this.lastProgress = this.tile.getProgress();
    }

    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.tile.setProgress(data);
                break;
            }
            case 1: {
                this.energyIndicator.setEnergy(data);
                break;
            }
            case 2: {
                this.energyIndicator.updateEnergy(data);
            }
        }
    }

    public final void func_75130_a(IInventory inv) {
        ItemStack output = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.tile.func_145831_w());
        this.craftResult.func_70299_a(0, output);
    }

    @Override
    public ItemStack func_75144_a(int i, int j, int modifier, EntityPlayer entityplayer) {
        ItemStack stack = super.func_75144_a(i, j, modifier, entityplayer);
        this.func_75130_a((IInventory)this.craftMatrix);
        return stack;
    }

    private class SlotRollingMachine
    extends SlotUntouchable {
        public SlotRollingMachine(IInventory contents, int id, int x, int y) {
            super(contents, id, x, y);
        }

        public void func_82870_a(EntityPlayer player, ItemStack itemstack) {
            ((ContainerRollingMachine)ContainerRollingMachine.this).tile.useLast = true;
        }
    }
}

