/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.FluidRegistrar;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.ForestryFluidRegistrar;
import mods.railcraft.common.fluids.ForgeFluidRegistrar;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.items.ModItems;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int BUCKET_VOLUME = 1000;
    public static final int PROCESS_VOLUME = Integer.MAX_VALUE;
    private static final List<FluidRegistrar> adapters = new ArrayList<FluidRegistrar>();

    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            FluidStack available;
            FluidItemHelper.DrainReturn drainReturn = FluidItemHelper.drainContainer(current, Integer.MAX_VALUE);
            if (fill && drainReturn.fluidDrained != null) {
                int used = tank.fill(side, drainReturn.fluidDrained, false);
                if (used > 0) {
                    drainReturn = FluidItemHelper.drainContainer(current, used);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (drainReturn.container != null && !player.field_71071_by.func_70441_a(drainReturn.container)) {
                                return false;
                            }
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, drainReturn.container);
                        }
                        player.field_71071_by.func_70296_d();
                        player.field_71069_bz.func_75142_b();
                    }
                    tank.fill(side, drainReturn.fluidDrained, true);
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null) {
                FluidItemHelper.FillReturn fillReturn = FluidItemHelper.fillContainer(current, available);
                if (fillReturn.amount > 0) {
                    if (current.field_77994_a > 1) {
                        if (fillReturn.container != null && !player.field_71071_by.func_70441_a(fillReturn.container)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, fillReturn.container);
                    }
                    player.field_71071_by.func_70296_d();
                    player.field_71069_bz.func_75142_b();
                    tank.drain(side, fillReturn.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, tank.getFluidType(), true, true);
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        TankManager tankManger = new TankManager();
        tankManger.add(tank);
        FluidHelper.processContainers(tankManger, inv, inputSlot, outputSlot, fluidToFill, processFilled, processEmpty);
    }

    public static void processContainers(TankManager tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, fluidToFill, true, true);
    }

    public static void processContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return;
        }
        if (processFilled && FluidHelper.drainContainers(fluidHandler, inv, inputSlot, outputSlot)) {
            return;
        }
        if (processEmpty && fluidToFill != null) {
            FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill);
        }
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidStack drain;
        if (fluidToFill == null) {
            return false;
        }
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        FluidItemHelper.FillReturn fill = FluidItemHelper.fillContainer(input, new FluidStack(fluidToFill, Integer.MAX_VALUE));
        if (fill.container != null && FluidHelper.hasPlaceToPutContainer(output, fill.container) && (drain = fluidHandler.drain(ForgeDirection.UNKNOWN, fill.amount, false)) != null && drain.amount == fill.amount) {
            fill = FluidItemHelper.fillContainer(input, drain);
            if (fill.container != null && fill.amount == drain.amount) {
                fluidHandler.drain(ForgeDirection.UNKNOWN, fill.amount, true);
                FluidHelper.storeContainer(inv, inputSlot, outputSlot, fill.container);
            }
            return true;
        }
        return false;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null) {
            FluidItemHelper.DrainReturn drain = FluidItemHelper.drainContainer(input, Integer.MAX_VALUE);
            if (drain.fluidDrained != null && (drain.container == null || FluidHelper.hasPlaceToPutContainer(output, drain.container))) {
                int used = fluidHandler.fill(ForgeDirection.UNKNOWN, drain.fluidDrained, false);
                if (drain.isAtomic && used == drain.fluidDrained.amount || !drain.isAtomic && drain.fluidDrained.amount > 0) {
                    fluidHandler.fill(ForgeDirection.UNKNOWN, drain.fluidDrained, true);
                    FluidHelper.storeContainer(inv, inputSlot, outputSlot, drain.container);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasPlaceToPutContainer(ItemStack output, ItemStack container) {
        if (output == null) {
            return true;
        }
        return output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(container, output);
    }

    private static void storeContainer(IInventory inv, int inputSlot, int outputSlot, ItemStack container) {
        if (container == null) {
            inv.func_70298_a(inputSlot, 1);
            return;
        }
        ItemStack output = inv.func_70301_a(outputSlot);
        if (output == null) {
            inv.func_70299_a(outputSlot, container);
        } else {
            ++output.field_77994_a;
        }
        inv.func_70298_a(inputSlot, 1);
    }

    public static boolean registerBucket(FluidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Items.field_151133_ar);
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerBottle(FluidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Items.field_151069_bo);
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerWax(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.waxCapsule.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerRefactory(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.refractoryEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerCan(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.canEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    public static boolean registerCell(FluidStack liquid, ItemStack filled) {
        ItemStack empty = ModItems.cellEmpty.get();
        return FluidHelper.registerContainer(liquid, filled, empty);
    }

    private static boolean registerContainer(FluidStack fluidStack, ItemStack filled, ItemStack empty) {
        if (empty != null) {
            FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(fluidStack, filled, empty);
            FluidHelper.registerContainer(container);
            return true;
        }
        return false;
    }

    public static void registerContainer(FluidContainerRegistry.FluidContainerData container) {
        for (FluidRegistrar adapter : adapters) {
            adapter.registerContainer(container);
        }
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            FluidStack inContainer = FluidItemHelper.getFluidStackInContainer(data.filledContainer);
            if (inContainer == null || !inContainer.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer.func_77946_l());
        }
        return containers;
    }

    public static void nerfWaterBottle() {
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (data.filledContainer.func_77973_b() != Items.field_151068_bn || data.emptyContainer.func_77973_b() != Items.field_151069_bo || !Fluids.WATER.is(data.fluid)) continue;
            data.fluid.amount = 333;
            return;
        }
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return FluidHelper.drainBlock(world.func_147439_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (fluidBlock.canDrain(world, x, y, z)) {
                return fluidBlock.drain(world, x, y, z, doDrain);
            }
        } else {
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return FluidHelper.isFullFluidBlock(WorldPlugin.getBlock((IBlockAccess)world, x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    public static int getFluidId(FluidStack stack) {
        if (stack == null) {
            return -1;
        }
        if (stack.getFluid() == null) {
            return -1;
        }
        return FluidRegistry.getFluidID((String)stack.getFluid().getName());
    }

    static {
        adapters.add(ForestryFluidRegistrar.INSTANCE);
        adapters.add(ForgeFluidRegistrar.INSTANCE);
    }
}

