/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.ItemStackMap;
import mods.railcraft.common.util.inventory.ItemStackSet;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileItemLoader
extends TileLoaderItemBase {
    private final Map<ItemStack, Short> transferredItems = new ItemStackMap<Short>();
    private final Set<ItemStack> checkedItems = new ItemStackSet();
    private final AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, this.tileCache, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return !(tile instanceof TileItemLoader);
        }
    }, InventorySorter.SIZE_DECENDING);
    private final InventoryMapper invBuffer;
    private final LinkedList<IInventory> chests = new LinkedList();

    public TileItemLoader() {
        this.setInventorySize(9);
        this.invBuffer = new InventoryMapper((IInventory)this, false);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_LOADER;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public Slot getBufferSlot(int id, int x, int y) {
        return new Slot((IInventory)this, id, x, y);
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.DOWN;
    }

    @Override
    public void func_145845_h() {
        TileLoaderItemBase.EnumRedstoneMode state;
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.movedItemCart = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.1f, this.getOrientation());
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.transferredItems.clear();
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (this.isPaused()) {
            return;
        }
        this.chests.clear();
        this.chests.addAll(this.invCache.getAdjacentInventories());
        this.chests.addFirst(this.invBuffer);
        this.checkedItems.clear();
        IInventory cartInv = (IInventory)cart;
        block0 : switch (this.getMode()) {
            case TRANSFER: {
                ItemStack moved;
                boolean hasFilter = false;
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved2;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    Short numMoved = this.transferredItems.get(filter);
                    if (numMoved == null) {
                        numMoved = 0;
                    }
                    if (numMoved >= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved2 = InvTools.moveOneItem(this.chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    Short s = numMoved;
                    Short s2 = numMoved = Short.valueOf((short)(numMoved + 1));
                    this.transferredItems.put(moved2, numMoved);
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(this.chests, cartInv, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
            case STOCK: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems(cartInv, filter);
                    if (stocked >= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem(this.chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    break block0;
                }
                break;
            }
            case EXCESS: {
                for (ItemStack filter : this.getItemFilters().getContents()) {
                    ItemStack moved;
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    int stocked = InvTools.countItems(this.chests, filter);
                    if (stocked <= InvTools.countItems((IInventory)this.getItemFilters(), filter) || (moved = InvTools.moveOneItem(this.chests, cartInv, filter)) == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (this.movedItemCart) break;
                this.movedItemCart = InvTools.moveOneItemExcept(this.chests, cartInv, this.getItemFilters().getContents()) != null;
                break;
            }
            case ALL: {
                boolean hasFilter = false;
                ItemStack moved = this.getItemFilters().getContents();
                int n = ((ItemStack[])moved).length;
                for (int i = 0; i < n; ++i) {
                    ItemStack filter = moved[i];
                    if (filter == null || !this.checkedItems.add(filter)) continue;
                    hasFilter = true;
                    ItemStack moved3 = InvTools.moveOneItem(this.chests, cartInv, filter);
                    if (moved3 == null) continue;
                    this.movedItemCart = true;
                    break;
                }
                if (hasFilter || (moved = InvTools.moveOneItem(this.chests, cartInv, new ItemStack[0])) == null) break;
                this.movedItemCart = true;
                break;
            }
        }
        if (this.movedItemCart) {
            this.setPowered(false);
        }
        if ((state = this.getRedstoneModeController().getButtonState()) != TileLoaderItemBase.EnumRedstoneMode.MANUAL && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IInventory)) {
            return true;
        }
        IInventory cartInv = (IInventory)cart;
        TileLoaderItemBase.EnumRedstoneMode state = this.getRedstoneModeController().getButtonState();
        if (!this.movedItemCart && state != TileLoaderItemBase.EnumRedstoneMode.COMPLETE) {
            if (state != TileLoaderItemBase.EnumRedstoneMode.PARTIAL) return true;
            if (InvTools.isInventoryEmpty(cartInv)) return false;
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.TRANSFER && this.isTransferComplete(this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.STOCK && this.isStockComplete(cartInv, this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.EXCESS && this.isExcessComplete(this.chests, this.getItemFilters().getContents())) {
            return true;
        }
        if (this.getMode() == TileLoaderItemBase.EnumTransferMode.ALL && this.isAllComplete(cartInv, this.getItemFilters().getContents())) {
            return true;
        }
        if (this.movedItemCart || !InvTools.isInventoryFull(cartInv, this.getOrientation().getOpposite())) return false;
        return true;
    }

    private boolean isTransferComplete(ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            Short numMoved = this.transferredItems.get(filter);
            if (numMoved != null && numMoved >= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return hasFilter;
    }

    private boolean isStockComplete(IInventory cart, ItemStack[] filters) {
        this.checkedItems.clear();
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems(cart, filter);
            if (stocked >= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return true;
    }

    private boolean isExcessComplete(List<IInventory> chests, ItemStack[] filters) {
        this.checkedItems.clear();
        int max = 0;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            int stocked = InvTools.countItems(chests, filter);
            max += filter.field_77994_a;
            if (stocked <= InvTools.countItems((IInventory)this.getItemFilters(), filter)) continue;
            return false;
        }
        return InvTools.countItems(chests, new ItemStack[0]) <= max;
    }

    private boolean isAllComplete(IInventory cart, ItemStack[] filters) {
        this.checkedItems.clear();
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null || !this.checkedItems.add(filter)) continue;
            hasFilter = true;
            if (InvTools.countItems(cart, filter) <= 0) continue;
            return false;
        }
        return hasFilter;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_ITEM, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

