/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import buildcraft.api.statements.IActionExternal;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.emblems.EmblemToolsServer;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngravingBench
extends TileMachineItem
implements IEnergyHandler,
ISidedInventory,
IHasWork,
IGuiReturnHandler {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 50;
    private static final int MAX_RECEIVE = 1000;
    private static final int MAX_ENERGY = 7500;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_RESULT = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    private final IInventory invResult = new InventoryMapper(this, 1, 1, false);
    private EnergyStorage energyStorage;
    private int progress;
    public boolean paused;
    public boolean startCrafting;
    public boolean isCrafting;
    public boolean flippedAxis;
    public String currentEmblem = "";
    private final Set<IActionExternal> actions = new HashSet<IActionExternal>();

    public TileEngravingBench() {
        super(2);
        if (RailcraftConfig.machinesRequirePower()) {
            this.energyStorage = new EnergyStorage(7500, 1000);
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.ENGRAVING_BENCH;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            if (this.flippedAxis) {
                return this.getMachineType().getTexture(6);
            }
            return this.getMachineType().getTexture(1);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("flippedAxis", this.flippedAxis);
        data.func_74757_a("isCrafting", this.isCrafting);
        data.func_74768_a("progress", this.progress);
        data.func_74778_a("currentEmblem", this.currentEmblem);
        if (this.energyStorage != null) {
            this.energyStorage.writeToNBT(data);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.flippedAxis = data.func_74767_n("flippedAxis");
        this.isCrafting = data.func_74767_n("isCrafting");
        this.progress = data.func_74762_e("progress");
        this.currentEmblem = data.func_74779_i("currentEmblem");
        if (this.energyStorage != null) {
            this.energyStorage.readFromNBT(data);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.flippedAxis);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.flippedAxis = data.readBoolean();
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        GuiPacketType type = GuiPacketType.values()[data.readByte()];
        switch (type) {
            case START_CRAFTING: {
                this.startCrafting = true;
            }
            case NORMAL_RETURN: {
                this.currentEmblem = data.readUTF();
                break;
            }
            case OPEN_UNLOCK: {
                GuiHandler.openGui(EnumGui.ENGRAVING_BENCH_UNLOCK, sender, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case OPEN_NORMAL: {
                GuiHandler.openGui(EnumGui.ENGRAVING_BENCH, sender, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case UNLOCK_EMBLEM: {
                if (EmblemToolsServer.manager == null) break;
                byte windowId = data.readByte();
                String code = data.readUTF();
                EmblemToolsServer.manager.unlockEmblem((EntityPlayerMP)sender, code, windowId);
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ENGRAVING_BENCH, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        if (this.clock % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        if (this.startCrafting) {
            this.startCrafting = false;
            this.isCrafting = true;
        }
        if (this.func_70301_a(1) != null) {
            this.isCrafting = false;
        }
        if (!this.isCrafting) {
            this.progress = 0;
            return;
        }
        ItemStack emblem = this.makeEmblem();
        if (emblem == null) {
            return;
        }
        if (!this.func_94041_b(0, this.func_70301_a(0))) {
            this.progress = 0;
            return;
        }
        if (this.progress >= 100) {
            this.isCrafting = false;
            if (InvTools.isRoomForStack(emblem, this.invResult)) {
                this.func_70298_a(0, 1);
                InvTools.moveItemStack(emblem, this.invResult);
                this.progress = 0;
            }
        } else if (this.energyStorage != null) {
            int energy = this.energyStorage.extractEnergy(50, true);
            if (energy >= 50) {
                ++this.progress;
                this.energyStorage.extractEnergy(50, false);
            }
        } else {
            ++this.progress;
        }
    }

    private ItemStack makeEmblem() {
        if (this.currentEmblem == null || this.currentEmblem.isEmpty() || EmblemToolsServer.manager == null) {
            return null;
        }
        return EmblemToolsServer.manager.getEmblemItemStack(this.currentEmblem);
    }

    @Override
    public boolean hasWork() {
        return this.isCrafting;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IActionExternal action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IActionExternal action) {
        this.actions.add(action);
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 1) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            return false;
        }
        if (OreDictPlugin.isOreType("ingotSteel", stack)) {
            return true;
        }
        if (OreDictPlugin.isOreType("ingotBronze", stack)) {
            return true;
        }
        return Items.field_151043_k == stack.func_77973_b();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        ForgeDirection facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
        if (facing == ForgeDirection.EAST || facing == ForgeDirection.WEST) {
            this.flippedAxis = true;
        }
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.flippedAxis = !this.flippedAxis;
        this.sendUpdateToClient();
        return true;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean canConnectEnergy(ForgeDirection side) {
        return this.energyStorage != null;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public static enum GuiPacketType {
        START_CRAFTING,
        NORMAL_RETURN,
        OPEN_UNLOCK,
        OPEN_NORMAL,
        UNLOCK_EMBLEM;

    }
}

