/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.VillagerRegistry;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.client.core.AuraKeyHandler;
import mods.railcraft.client.core.DebugViewTicker;
import mods.railcraft.client.core.LatestVersionMessage;
import mods.railcraft.client.core.LocomotiveKeyHandler;
import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.client.render.RenderBlockFrame;
import mods.railcraft.client.render.RenderBlockLamp;
import mods.railcraft.client.render.RenderBlockMachineBeta;
import mods.railcraft.client.render.RenderBlockMachineDelta;
import mods.railcraft.client.render.RenderBlockMachineEta;
import mods.railcraft.client.render.RenderBlockMachineZeta;
import mods.railcraft.client.render.RenderBlockOre;
import mods.railcraft.client.render.RenderBlockPost;
import mods.railcraft.client.render.RenderBlockPostMetal;
import mods.railcraft.client.render.RenderBlockSignal;
import mods.railcraft.client.render.RenderBlockStrengthGlass;
import mods.railcraft.client.render.RenderCagedEntity;
import mods.railcraft.client.render.RenderChest;
import mods.railcraft.client.render.RenderElevator;
import mods.railcraft.client.render.RenderFluidLoader;
import mods.railcraft.client.render.RenderIronTank;
import mods.railcraft.client.render.RenderPneumaticEngine;
import mods.railcraft.client.render.RenderSlab;
import mods.railcraft.client.render.RenderStair;
import mods.railcraft.client.render.RenderTESRFirestone;
import mods.railcraft.client.render.RenderTESRSignals;
import mods.railcraft.client.render.RenderTrack;
import mods.railcraft.client.render.RenderTrackBuffer;
import mods.railcraft.client.render.RenderTurbineGauge;
import mods.railcraft.client.render.RenderWall;
import mods.railcraft.client.render.carts.CartContentRendererRedstoneFlux;
import mods.railcraft.client.render.carts.LocomotiveRendererDefault;
import mods.railcraft.client.render.carts.LocomotiveRendererElectric;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.client.render.carts.RenderCartItemFiltered;
import mods.railcraft.client.render.carts.RenderItemLocomotive;
import mods.railcraft.client.render.carts.RenderTunnelBore;
import mods.railcraft.client.render.models.locomotives.ModelLocomotiveSteamMagic;
import mods.railcraft.client.render.models.locomotives.ModelLocomotiveSteamSolid;
import mods.railcraft.client.sounds.RCSoundHandler;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import mods.railcraft.common.blocks.aesthetics.post.TilePostEmblem;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import mods.railcraft.common.blocks.machine.beta.TileChestMetals;
import mods.railcraft.common.blocks.machine.beta.TileChestVoid;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHigh;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamLow;
import mods.railcraft.common.blocks.machine.beta.TileTankIronGauge;
import mods.railcraft.common.blocks.machine.beta.TileTankIronValve;
import mods.railcraft.common.blocks.machine.beta.TileTankIronWall;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelGauge;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelValve;
import mods.railcraft.common.blocks.machine.beta.TileTankSteelWall;
import mods.railcraft.common.blocks.machine.delta.TileCage;
import mods.railcraft.common.blocks.machine.gamma.TileFluidLoader;
import mods.railcraft.common.blocks.machine.gamma.TileFluidUnloader;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankGauge;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankValve;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankWall;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.tracks.TileTrackTESR;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.CommonProxy;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.firestone.TileFirestoneRecharge;
import mods.railcraft.common.modules.ModuleWorld;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class ClientProxy
extends CommonProxy {
    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.func_77973_b().func_77653_i(stack);
    }

    @Override
    public String getCurrentLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    @Override
    public int getRenderId() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    @Override
    public void preInitClient() {
        MinecraftForge.EVENT_BUS.register((Object)RCSoundHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new TextureHook());
    }

    @Override
    public void initClient() {
        FMLCommonHandler.instance().bus().register((Object)new LatestVersionMessage());
        SoundRegistry.setupBlockSounds();
        FMLCommonHandler.instance().bus().register((Object)LocomotiveKeyHandler.INSTANCE);
        if (!ItemGoggles.areEnabled()) {
            FMLCommonHandler.instance().bus().register((Object)AuraKeyHandler.INSTANCE);
        }
        Game.log(Level.TRACE, "Init Start: Renderer", new Object[0]);
        LocomotiveRenderType.STEAM_SOLID.registerRenderer(new LocomotiveRendererDefault("railcraft:default", "locomotive.model.steam.solid.default", new ModelLocomotiveSteamSolid()));
        LocomotiveRenderType.STEAM_MAGIC.registerRenderer(new LocomotiveRendererDefault("railcraft:default", "locomotive.model.steam.magic.default", new ModelLocomotiveSteamMagic()));
        LocomotiveRenderType.ELECTRIC.registerRenderer(new LocomotiveRendererElectric());
        ItemStack stack = LocomotiveRenderType.STEAM_SOLID.getItemWithRenderer("railcraft:default");
        if (stack != null) {
            MinecraftForgeClient.registerItemRenderer((Item)stack.func_77973_b(), (IItemRenderer)new RenderItemLocomotive(LocomotiveRenderType.STEAM_SOLID, (EntityLocomotive)EnumCart.LOCO_STEAM_SOLID.makeCart(stack, null, 0.0, 0.0, 0.0)));
        }
        if ((stack = LocomotiveRenderType.STEAM_MAGIC.getItemWithRenderer("railcraft:default")) != null) {
            MinecraftForgeClient.registerItemRenderer((Item)stack.func_77973_b(), (IItemRenderer)new RenderItemLocomotive(LocomotiveRenderType.STEAM_MAGIC, (EntityLocomotive)EnumCart.LOCO_STEAM_MAGIC.makeCart(stack, null, 0.0, 0.0, 0.0)));
        }
        if ((stack = LocomotiveRenderType.ELECTRIC.getItemWithRenderer("railcraft:default")) != null) {
            MinecraftForgeClient.registerItemRenderer((Item)stack.func_77973_b(), (IItemRenderer)new RenderItemLocomotive(LocomotiveRenderType.ELECTRIC, (EntityLocomotive)EnumCart.LOCO_ELECTRIC.makeCart(stack, null, 0.0, 0.0, 0.0)));
        }
        RenderFluidLoader fluidLoaderRenderer = new RenderFluidLoader();
        ClientRegistry.bindTileEntitySpecialRenderer(TileFluidLoader.class, (TileEntitySpecialRenderer)fluidLoaderRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileFluidUnloader.class, (TileEntitySpecialRenderer)fluidLoaderRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankIronGauge.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankIronWall.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankIronValve.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankSteelGauge.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankSteelWall.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankSteelValve.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGenericMultiTankGauge.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGenericMultiTankWall.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGenericMultiTankValve.class, (TileEntitySpecialRenderer)new RenderIronTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineSteamHobby.class, (TileEntitySpecialRenderer)RenderPneumaticEngine.renderHobby);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineSteamLow.class, (TileEntitySpecialRenderer)RenderPneumaticEngine.renderLow);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineSteamHigh.class, (TileEntitySpecialRenderer)RenderPneumaticEngine.renderHigh);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCage.class, (TileEntitySpecialRenderer)new RenderCagedEntity());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTrackTESR.class, (TileEntitySpecialRenderer)new RenderTrackBuffer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileChestVoid.class, (TileEntitySpecialRenderer)new RenderChest("railcraft:textures/tesr/chest_void.png", new TileChestVoid()));
        ClientRegistry.bindTileEntitySpecialRenderer(TileChestMetals.class, (TileEntitySpecialRenderer)new RenderChest("railcraft:textures/tesr/chest_metals.png", new TileChestMetals()));
        ClientRegistry.bindTileEntitySpecialRenderer(TilePostEmblem.class, (TileEntitySpecialRenderer)new RenderBlockPost.EmblemPostTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFirestoneRecharge.class, (TileEntitySpecialRenderer)new RenderTESRFirestone());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSteamTurbine.class, (TileEntitySpecialRenderer)new RenderTurbineGauge());
        RenderTESRSignals controllerRenderer = new RenderTESRSignals();
        ClientRegistry.bindTileEntitySpecialRenderer(TileSignalFoundation.class, (TileEntitySpecialRenderer)controllerRenderer);
        if (RailcraftBlocks.getBlockTrack() != null) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderTrack());
        }
        if (RailcraftBlocks.getBlockElevator() != null) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderElevator());
        }
        this.registerBlockRenderer(new RenderBlockMachineBeta());
        this.registerBlockRenderer(new RenderBlockMachineDelta());
        this.registerBlockRenderer(new RenderBlockMachineEta());
        this.registerBlockRenderer(new RenderBlockMachineZeta());
        this.registerBlockRenderer(new RenderBlockSignal());
        this.registerBlockRenderer(RenderBlockPost.make());
        this.registerBlockRenderer(RenderBlockPostMetal.make(BlockPostMetal.post));
        this.registerBlockRenderer(RenderBlockPostMetal.make(BlockPostMetal.platform));
        this.registerBlockRenderer(new RenderBlockOre());
        this.registerBlockRenderer(new RenderBlockFrame());
        this.registerBlockRenderer(new RenderBlockStrengthGlass());
        this.registerBlockRenderer(new RenderBlockLamp(BlockLantern.getBlockStone()));
        this.registerBlockRenderer(new RenderBlockLamp(BlockLantern.getBlockMetal()));
        this.registerBlockRenderer(new RenderWall((Block)BlockRailcraftWall.getBlockAlpha()));
        this.registerBlockRenderer(new RenderWall((Block)BlockRailcraftWall.getBlockBeta()));
        this.registerBlockRenderer(new RenderStair());
        this.registerBlockRenderer(new RenderSlab());
        RenderingRegistry.registerEntityRenderingHandler(EntityTunnelBore.class, (Render)new RenderTunnelBore());
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecart.class, (Render)new RenderCart());
        stack = EnumCart.TANK.getCartItem();
        if (stack != null) {
            MinecraftForgeClient.registerItemRenderer((Item)stack.func_77973_b(), (IItemRenderer)new RenderCartItemFiltered(RenderCartItemFiltered.RendererType.Tank));
        }
        if ((stack = EnumCart.CARGO.getCartItem()) != null) {
            MinecraftForgeClient.registerItemRenderer((Item)stack.func_77973_b(), (IItemRenderer)new RenderCartItemFiltered(RenderCartItemFiltered.RendererType.Cargo));
        }
        Minecraft.func_71410_x().field_71460_t.field_78532_q = 0;
        FMLCommonHandler.instance().bus().register((Object)new DebugViewTicker());
        if (RailcraftConfig.isWorldGenEnabled("workshop")) {
            int id = RailcraftConfig.villagerID();
            VillagerRegistry.instance().registerVillagerSkin(id, ModuleWorld.VILLAGER_TEXTURE);
        }
        Game.log(Level.TRACE, "Init Complete: Renderer", new Object[0]);
    }

    private void registerBlockRenderer(BlockRenderer renderer) {
        if (renderer.getBlock() != null) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)renderer.getBlock()), (IItemRenderer)renderer.getItemRenderer());
        }
    }

    public static class TextureHook {
        @SubscribeEvent
        public void textureStitch(TextureStitchEvent.Pre event) {
            if (event.map.func_130086_a() == 0) {
                CartContentRendererRedstoneFlux.instance().setRedstoneIcon(event.map.func_94245_a("railcraft:cart.redstone.flux"));
                CartContentRendererRedstoneFlux.instance().setFrameIcon(event.map.func_94245_a("railcraft:cart.redstone.flux.frame"));
            }
        }
    }
}

