/*
 * Decompiled with CFR 0.152.
 */
package rwg.terrain;

import rwg.terrain.TerrainBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class TerrainHilly
extends TerrainBase {
    private float width;
    private float strength;
    private float lakeDepth;
    private float lakeWidth;
    private float terrainHeight;

    public TerrainHilly(float mountainWidth, float mountainStrength, float depthLake) {
        this(mountainWidth, mountainStrength, depthLake, 260.0f, 68.0f);
    }

    public TerrainHilly(float mountainWidth, float mountainStrength, float depthLake, float widthLake, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.lakeDepth = depthLake;
        this.lakeWidth = widthLake;
        this.terrainHeight = height;
    }

    @Override
    public float generateNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        float h = perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        h += perlin.noise2((float)x / 7.0f, (float)y / 7.0f) * 0.8f;
        float m = perlin.noise2((float)x / this.width, (float)y / this.width) * this.strength * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = cell.noise((float)x / 30.0f, (float)y / 30.0f, 1.0) * (5.0f + st);
        float sm = perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f + perlin.noise2((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        float l = perlin.noise2((float)x / this.lakeWidth, (float)y / this.lakeWidth) * this.lakeDepth;
        l *= l / 25.0f;
        l = l < -8.0f ? -8.0f : l;
        return this.terrainHeight + h + (m += c) - l;
    }
}

