/*
 * Decompiled with CFR 0.152.
 */
package rwg.support;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.support.edit.EditBase;
import rwg.surface.SurfaceBase;
import rwg.terrain.TerrainBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeSupport
extends RealisticBiomeBase {
    public BiomeGenBase customBiome;
    public TerrainBase terrain;
    public SurfaceBase[] surfaces;
    public int surfacesLength;
    public EditBase[] edits;
    public int editLength;

    public RealisticBiomeSupport(BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase[] s, EditBase[] e) {
        super(0, b, RealisticBiomeBase.coastDunes, riverbiome);
        this.customBiome = b;
        this.terrain = t;
        this.surfaces = s;
        this.surfacesLength = s.length;
        if (e != null) {
            this.edits = e;
            this.editLength = e.length;
        } else {
            this.editLength = 0;
        }
    }

    public RealisticBiomeSupport(BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s, EditBase e) {
        EditBase[] editBaseArray;
        SurfaceBase[] surfaceBaseArray = new SurfaceBase[]{s};
        if (e != null) {
            EditBase[] editBaseArray2 = new EditBase[1];
            editBaseArray = editBaseArray2;
            editBaseArray2[0] = e;
        } else {
            editBaseArray = null;
        }
        this(b, riverbiome, t, surfaceBaseArray, editBaseArray);
    }

    public RealisticBiomeSupport(BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        this(b, riverbiome, t, s, null);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        if (strength > 0.3f) {
            this.customBiome.func_76728_a(world, rand, chunkX, chunkY);
        }
        for (int e = 0; e < this.editLength; ++e) {
            this.edits[e].decorate(world, rand, chunkX, chunkY, perlin, cell, strength, river);
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        for (int s = 0; s < this.surfacesLength; ++s) {
            this.surfaces[s].paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
        }
    }
}

