/*
 * Decompiled with CFR 0.152.
 */
package rwg.map;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.util.TerrainMath;

public class MapVolcano {
    public static void build(Block[] blocks, byte[] metadata, World world, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float[] noise) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int y;
                float height;
                int i = chunkX * 16 + x;
                int j = chunkY * 16 + z;
                float distance = (float)TerrainMath.dis2(i, j, baseX * 16, baseY * 16);
                float obsidian = 140.0f + distance + perlin.noise2((float)i / 16.0f, (float)j / 16.0f) * 15.0f;
                if (distance < 10.0f + perlin.noise2((float)i / 3.0f, (float)j / 3.0f) * 1.5f) {
                    height = perlin.noise2((float)i / 5.0f, (float)j / 5.0f) * 2.0f;
                    for (y = 255; y > -1; --y) {
                        if (y > 165) {
                            if (blocks[MapVolcano.cta(x, y, z)] == Blocks.field_150350_a) continue;
                            blocks[MapVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                            continue;
                        }
                        if ((float)y > obsidian && (float)y < 156.0f + height) {
                            blocks[MapVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150343_Z;
                            continue;
                        }
                        if (y < 166) {
                            blocks[MapVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150353_l;
                            continue;
                        }
                        if (!((float)y < obsidian + 1.0f)) continue;
                        if (blocks[MapVolcano.cta(x, y, z)] != Blocks.field_150350_a) continue block1;
                        blocks[MapVolcano.cta((int)x, (int)y, (int)z)] = Blocks.field_150348_b;
                    }
                    continue;
                }
                height = 190.0f - (distance + perlin.noise2((float)i / 12.0f, (float)j / 12.0f) * 5.0f) * 1.7f;
                if (height > noise[x * 16 + z]) {
                    noise[x * 16 + z] = height;
                }
                for (y = 255; y > -1; --y) {
                    if (!((float)y <= height)) continue;
                    Block b = blocks[MapVolcano.cta(x, y, z)];
                    if (b != Blocks.field_150350_a) continue block1;
                    b = (float)y > obsidian ? Blocks.field_150343_Z : Blocks.field_150348_b;
                    blocks[MapVolcano.cta((int)x, (int)y, (int)z)] = b;
                }
            }
        }
    }

    public static int cta(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }
}

