/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.savanna;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoCacti;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoSavannah;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceMountainStoneMix1;
import rwg.surface.river.SurfaceRiverOasis;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainHilly;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeStoneMountainsCactus
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainHilly(230.0f, 120.0f, 0.0f);
    private SurfaceBase surface = new SurfaceMountainStoneMix1((Block)Blocks.field_150349_c, Blocks.field_150346_d, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150348_b, 0.2f);
    private SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeStoneMountainsCactus() {
        super(0, RWGBiomes.baseHotPlains, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int i23;
        int i18;
        int z52;
        int k10;
        int j6;
        for (int i232 = 0; i232 < 1; ++i232) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 >= 80) continue;
            new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    j6 = chunkX + rand.nextInt(16) + 8;
                    z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            int k18 = 0;
            while ((float)k18 < 12.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                i18 = chunkX + rand.nextInt(16) + 8;
                i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        } else {
            int a = 6 - (int)(perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 10.0f);
            if ((a < 1 || rand.nextInt(a) == 0) && ((float)(z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0)) {
                Object worldgenerator = rand.nextInt(14) != 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            for (int k18 = 0; k18 < 70; ++k18) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = 64 + rand.nextInt(64);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if (!((float)j23 < 120.0f)) continue;
                new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0) {
                i18 = chunkX + rand.nextInt(16) + 8;
                i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
        this.riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

