/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.savanna;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoLog;
import rwg.deco.DecoWaterGrass;
import rwg.deco.trees.DecoBirch;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceGrasslandMixBig;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainGrasslandFlats;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeHotForest
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainGrasslandFlats();
    private SurfaceBase surface = new SurfaceGrasslandMixBig((Block)Blocks.field_150354_m, (Block)Blocks.field_150354_m, (Block)Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150347_e, 60.0f, -0.14f, 14.0f, 0.25f);

    public RealisticBiomeHotForest() {
        super(0, RWGBiomes.baseHotForest, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverHot);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int j24;
        int k22;
        int l19;
        int l14;
        int i8;
        int i2;
        int l4;
        if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63) {
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
        }
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && (k1 < 64 || rand.nextInt(7) == 0)) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        float l2 = perlin.noise2(((float)chunkX + 16.0f) / 60.0f, ((float)chunkY + 16.0f) / 60.0f) * 6.0f + 0.2f;
        int b1 = 0;
        while ((float)b1 < l2 * 4.0f * strength) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            WorldGenTrees worldgenerator = rand.nextInt(6) == 0 ? new WorldGenTrees(false) : (rand.nextInt(12) == 0 ? new DecoBirch(4 + rand.nextInt(5), 6 + rand.nextInt(5)) : (rand.nextInt(6) == 0 ? new DecoSmallPine(3 + rand.nextInt(2), 3 + rand.nextInt(3), 0) : new DecoSmallPine(6 + rand.nextInt(5), 3 + rand.nextInt(6), 0)));
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            ++b1;
        }
        if (l2 < 0.5f) {
            l14 = 0;
            while ((float)l14 < (l2 + 2.0f) * 4.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = 64 + rand.nextInt(64);
                j24 = chunkY + rand.nextInt(16) + 8;
                new DecoWaterGrass((Block)Blocks.field_150329_H, 1, 65).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        }
        if (l2 > 0.0f && rand.nextInt(6) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new DecoLog(0, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int b = 0;
        while ((float)b < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(10) == 0) {
                new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), 0).func_76484_a(world, rand, i1, k1, j1);
            } else {
                new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++b;
        }
        if (rand.nextInt((int)(3.0f / strength)) == 0) {
            int k15 = chunkX + rand.nextInt(16) + 8;
            int k17 = rand.nextInt(64) + 64;
            int k20 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextBoolean()) {
                new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(world, rand, k15, k17, k20);
            } else {
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(world, rand, k15, k17, k20);
            }
        }
        if (rand.nextInt((int)(20.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int f23 = 0;
        while ((float)f23 < 4.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        l14 = 0;
        while ((float)l14 < 10.0f * strength) {
            l19 = chunkX + rand.nextInt(16) + 8;
            k22 = rand.nextInt(128);
            j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

