/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.land;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfacePolar;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainPolar;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomePolar
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainPolar();
    private SurfaceBase surface = new SurfacePolar(Blocks.field_150433_aE, Blocks.field_150433_aE);

    public RealisticBiomePolar() {
        super(0, RWGBiomes.baseSnowDesert, RealisticBiomeBase.coastIce, RWGBiomes.baseRiverIce);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        if (river > 0.86f) {
            int j = 0;
            while ((float)j < 5.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 64) {
                    new DecoBlob(Blocks.field_150403_cj, 0).func_76484_a(world, rand, i1, k1, j1);
                }
                ++j;
            }
            if (rand.nextInt((int)(2.0f / strength)) == 0) {
                int j6 = chunkX + rand.nextInt(16) + 8;
                int k10 = chunkY + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10);
                DecoSmallSpruce worldgenerator = new DecoSmallSpruce(rand.nextInt(2));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

