/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.coast;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoCacti;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoSavannah;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeCoastOasis
extends RealisticBiomeBase {
    public RealisticBiomeCoastOasis() {
        super(0, RWGBiomes.baseRiverOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        if (strength > 0.7f) {
            int b33 = 0;
            while ((float)b33 < 12.0f * strength) {
                int k10;
                int j6 = chunkX + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if ((float)z52 > 65.0f && (float)z52 < 90.0f) {
                    Object worldgenerator = rand.nextInt(3) != 0 ? new WorldGenShrub(0, 0) : (rand.nextInt(6) != 0 ? new DecoSavannah(1) : (rand.nextInt(5) != 0 ? new DecoSavannah(2) : new DecoSavannah(0)));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b33;
            }
        }
        int k18 = 0;
        while ((float)k18 < 12.0f * strength) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = rand.nextInt(160);
            int k24 = chunkY + rand.nextInt(16) + 8;
            if ((float)j23 < 120.0f) {
                new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
            }
            ++k18;
        }
        int f25 = 0;
        while ((float)f25 < 2.0f * strength) {
            int i18 = chunkX + rand.nextInt(16) + 8;
            int i23 = chunkY + rand.nextInt(16) + 8;
            new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            ++f25;
        }
        if (rand.nextInt(28) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        for (int f23 = 0; f23 < 3; ++f23) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
        }
        for (int l14 = 0; l14 < 15; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(6) == 0) {
                new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        river = river > 0.5f ? 1.0f : river * 2.0f;
        float start = perlin.noise2((float)x / 90.0f, (float)y / 90.0f) * 1.0f + perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 0.15f + perlin.noise2((float)x / 9.0f, (float)y / 9.0f) * 0.07f;
        float h = 0.0f;
        h = ocean < 1.0f ? ocean * 10.0f : 10.0f;
        float c = 0.0f;
        if (ocean + start > 1.0f) {
            c = ocean + start > 1.2f ? 0.2f : ocean + start - 1.0f;
            c *= 100.0f + perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 55.0f;
        }
        if (ocean < 1.2f) {
            float st = (1.2f - ocean) * 20.0f;
            st = st > 1.0f ? 1.0f : st;
            h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f);
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        }
        return 55.0f + h + c * river;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.4f;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (depth < 7 && k < 65) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                continue;
            }
            if (depth == 0) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 4) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
        }
    }
}

