/*
 * Decompiled with CFR 0.152.
 */
package rwg.util;

public class PerlinNoise {
    private static final double STRETCH_2D = -0.211324865405187;
    private static final double STRETCH_3D = -0.16666666666666666;
    private static final double SQUISH_2D = 0.366025403784439;
    private static final double SQUISH_3D = 0.3333333333333333;
    private static final long DEFAULT_SEED = 0L;
    private int[] perm = new int[256];
    private int[] perm2D = new int[256];
    private int[] perm3D = new int[256];
    private static Contribution3[] lookup3D;
    private static double[] gradients2D;
    private static double[] gradients3D;

    public PerlinNoise() {
        this(0L);
    }

    public PerlinNoise(long seed) {
        int i;
        int[] source = new int[256];
        for (i = 0; i < 256; ++i) {
            source[i] = i;
        }
        for (i = 255; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.perm2D[i] = this.perm[i] % 12 * 2;
            this.perm3D[i] = this.perm[i] % 24 * 3;
            source[r] = source[i];
        }
    }

    public float noise1(float x) {
        return (float)this.noise(x, 0.5);
    }

    public float noise2(float x, float y) {
        return (float)this.noise(x, y);
    }

    public float noise3(float x, float y, float z) {
        return (float)this.noise(x, y, z);
    }

    public double improvedNoise(double x, double y, double z) {
        return this.noise(x, y, z);
    }

    public double noise(double x, double y) {
        double attn_ext;
        double dy_ext;
        double dx_ext;
        int ysv_ext;
        int xsv_ext;
        double zins;
        double dy2;
        double dx2;
        double attn2;
        double stretchOffset = (x + y) * -0.211324865405187;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        int xsb = PerlinNoise.fastFloor(xs);
        int ysb = PerlinNoise.fastFloor(ys);
        double squishOffset = (double)(xsb + ysb) * 0.366025403784439;
        double xb = (double)xsb + squishOffset;
        double yb = (double)ysb + squishOffset;
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double inSum = xins + yins;
        double dx0 = x - xb;
        double dy0 = y - yb;
        double value = 0.0;
        double dx1 = dx0 - 1.0 - 0.366025403784439;
        double dy1 = dy0 - 0.0 - 0.366025403784439;
        double attn1 = 2.0 - dx1 * dx1 - dy1 * dy1;
        if (attn1 > 0.0) {
            attn1 *= attn1;
            value += attn1 * attn1 * this.extrapolate2D(xsb + 1, ysb + 0, dx1, dy1);
        }
        if ((attn2 = 2.0 - (dx2 = dx0 - 0.0 - 0.366025403784439) * dx2 - (dy2 = dy0 - 1.0 - 0.366025403784439) * dy2) > 0.0) {
            attn2 *= attn2;
            value += attn2 * attn2 * this.extrapolate2D(xsb + 0, ysb + 1, dx2, dy2);
        }
        if (inSum <= 1.0) {
            zins = 1.0 - inSum;
            if (zins > xins || zins > yins) {
                if (xins > yins) {
                    xsv_ext = xsb + 1;
                    ysv_ext = ysb - 1;
                    dx_ext = dx0 - 1.0;
                    dy_ext = dy0 + 1.0;
                } else {
                    xsv_ext = xsb - 1;
                    ysv_ext = ysb + 1;
                    dx_ext = dx0 + 1.0;
                    dy_ext = dy0 - 1.0;
                }
            } else {
                xsv_ext = xsb + 1;
                ysv_ext = ysb + 1;
                dx_ext = dx0 - 1.0 - 0.732050807568878;
                dy_ext = dy0 - 1.0 - 0.732050807568878;
            }
        } else {
            zins = 2.0 - inSum;
            if (zins < xins || zins < yins) {
                if (xins > yins) {
                    xsv_ext = xsb + 2;
                    ysv_ext = ysb + 0;
                    dx_ext = dx0 - 2.0 - 0.732050807568878;
                    dy_ext = dy0 + 0.0 - 0.732050807568878;
                } else {
                    xsv_ext = xsb + 0;
                    ysv_ext = ysb + 2;
                    dx_ext = dx0 + 0.0 - 0.732050807568878;
                    dy_ext = dy0 - 2.0 - 0.732050807568878;
                }
            } else {
                dx_ext = dx0;
                dy_ext = dy0;
                xsv_ext = xsb;
                ysv_ext = ysb;
            }
            ++xsb;
            ++ysb;
            dx0 = dx0 - 1.0 - 0.732050807568878;
            dy0 = dy0 - 1.0 - 0.732050807568878;
        }
        double attn0 = 2.0 - dx0 * dx0 - dy0 * dy0;
        if (attn0 > 0.0) {
            attn0 *= attn0;
            value += attn0 * attn0 * this.extrapolate2D(xsb, ysb, dx0, dy0);
        }
        if ((attn_ext = 2.0 - dx_ext * dx_ext - dy_ext * dy_ext) > 0.0) {
            attn_ext *= attn_ext;
            value += attn_ext * attn_ext * this.extrapolate2D(xsv_ext, ysv_ext, dx_ext, dy_ext);
        }
        return value;
    }

    public double noise(double x, double y, double z) {
        double stretchOffset = (x + y + z) * -0.16666666666666666;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        double zs = z + stretchOffset;
        int xsb = PerlinNoise.fastFloor(xs);
        int ysb = PerlinNoise.fastFloor(ys);
        int zsb = PerlinNoise.fastFloor(zs);
        double squishOffset = (double)(xsb + ysb + zsb) * 0.3333333333333333;
        double dx0 = x - ((double)xsb + squishOffset);
        double dy0 = y - ((double)ysb + squishOffset);
        double dz0 = z - ((double)zsb + squishOffset);
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double zins = zs - (double)zsb;
        double inSum = xins + yins + zins;
        int hash = (int)(yins - zins + 1.0) | (int)(xins - yins + 1.0) << 1 | (int)(xins - zins + 1.0) << 2 | (int)inSum << 3 | (int)(inSum + zins) << 5 | (int)(inSum + yins) << 7 | (int)(inSum + xins) << 9;
        Contribution3 c = lookup3D[hash];
        double value = 0.0;
        while (c != null) {
            double dx = dx0 + c.dx;
            double dy = dy0 + c.dy;
            double dz = dz0 + c.dz;
            double attn = 2.0 - dx * dx - dy * dy - dz * dz;
            if (attn > 0.0) {
                int px = xsb + c.xsb;
                int py = ysb + c.ysb;
                int pz = zsb + c.zsb;
                int i = this.perm3D[this.perm[this.perm[px & 0xFF] + py & 0xFF] + pz & 0xFF];
                double valuePart = gradients3D[i] * dx + gradients3D[i + 1] * dy + gradients3D[i + 2] * dz;
                attn *= attn;
                value += attn * attn * valuePart;
            }
            c = c.next;
        }
        return value;
    }

    private double extrapolate2D(int xsb, int ysb, double dx, double dy) {
        int index = this.perm2D[this.perm[xsb & 0xFF] + ysb & 0xFF];
        return gradients2D[index] * dx + gradients2D[index + 1] * dy;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    static {
        int i;
        int[][] base3D = new int[][]{{0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1}, {2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1, 3, 1, 1, 1}, {1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1}};
        int[] p3D = new int[]{0, 0, 1, -1, 0, 0, 1, 0, -1, 0, 0, -1, 1, 0, 0, 0, 1, -1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, 2, 1, 1, 0, 1, 1, 1, -1, 0, 2, 1, 0, 1, 1, 1, -1, 1, 0, 2, 0, 1, 1, 1, -1, 1, 1, 1, 3, 2, 1, 0, 3, 1, 2, 0, 1, 3, 2, 0, 1, 3, 1, 0, 2, 1, 3, 0, 2, 1, 3, 0, 1, 2, 1, 1, 1, 0, 0, 2, 2, 0, 0, 1, 1, 0, 1, 0, 2, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, -1, 1, 2, 0, 0, 0, 0, 1, -1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, -1, 2, 3, 1, 1, 1, 2, 0, 0, 2, 2, 3, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 1, 2, 0, 2, 0, 2, 1, 1, -1, 1, 2, 0, 0, 2, 2, 1, 1, -1, 1, 2, 2, 0, 0, 2, 1, -1, 1, 1, 2, 0, 0, 2, 2, 1, -1, 1, 1, 2, 0, 2, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0};
        int[] lookupPairs3D = new int[]{0, 2, 1, 1, 2, 2, 5, 1, 6, 0, 7, 0, 32, 2, 34, 2, 129, 1, 133, 1, 160, 5, 161, 5, 518, 0, 519, 0, 546, 4, 550, 4, 645, 3, 647, 3, 672, 5, 673, 5, 674, 4, 677, 3, 678, 4, 679, 3, 680, 13, 681, 13, 682, 12, 685, 14, 686, 12, 687, 14, 712, 20, 714, 18, 809, 21, 813, 23, 840, 20, 841, 21, 1198, 19, 1199, 22, 1226, 18, 1230, 19, 1325, 23, 1327, 22, 1352, 15, 1353, 17, 1354, 15, 1357, 17, 1358, 16, 1359, 16, 1360, 11, 1361, 10, 1362, 11, 1365, 10, 1366, 9, 1367, 9, 1392, 11, 1394, 11, 1489, 10, 1493, 10, 1520, 8, 1521, 8, 1878, 9, 1879, 9, 1906, 7, 1910, 7, 2005, 6, 2007, 6, 2032, 8, 2033, 8, 2034, 7, 2037, 6, 2038, 7, 2039, 6};
        Contribution3[] contributions3D = new Contribution3[p3D.length / 9];
        for (i = 0; i < p3D.length; i += 9) {
            int[] baseSet = base3D[p3D[i]];
            Contribution3 previous = null;
            Contribution3 current = null;
            for (int k = 0; k < baseSet.length; k += 4) {
                current = new Contribution3(baseSet[k], baseSet[k + 1], baseSet[k + 2], baseSet[k + 3]);
                if (previous == null) {
                    contributions3D[i / 9] = current;
                } else {
                    previous.next = current;
                }
                previous = current;
            }
            current.next = new Contribution3(p3D[i + 1], p3D[i + 2], p3D[i + 3], p3D[i + 4]);
            current.next.next = new Contribution3(p3D[i + 5], p3D[i + 6], p3D[i + 7], p3D[i + 8]);
        }
        lookup3D = new Contribution3[2048];
        for (i = 0; i < lookupPairs3D.length; i += 2) {
            PerlinNoise.lookup3D[lookupPairs3D[i]] = contributions3D[lookupPairs3D[i + 1]];
        }
        gradients2D = new double[]{0.114251372530929, 0.065963060686016, 0.131926121372032, 0.0, 0.114251372530929, -0.065963060686016, 0.065963060686016, -0.114251372530929, 0.0, -0.131926121372032, -0.065963060686016, -0.114251372530929, -0.114251372530929, -0.065963060686016, -0.131926121372032, -0.0, -0.114251372530929, 0.065963060686016, -0.065963060686016, 0.114251372530929, -0.0, 0.131926121372032, 0.065963060686016, 0.114251372530929};
        gradients3D = new double[]{-0.106796116504854, 0.0388349514563107, 0.0388349514563107, -0.0388349514563107, 0.106796116504854, 0.0388349514563107, -0.0388349514563107, 0.0388349514563107, 0.106796116504854, 0.106796116504854, 0.0388349514563107, 0.0388349514563107, 0.0388349514563107, 0.106796116504854, 0.0388349514563107, 0.0388349514563107, 0.0388349514563107, 0.106796116504854, -0.106796116504854, -0.0388349514563107, 0.0388349514563107, -0.0388349514563107, -0.106796116504854, 0.0388349514563107, -0.0388349514563107, -0.0388349514563107, 0.106796116504854, 0.106796116504854, -0.0388349514563107, 0.0388349514563107, 0.0388349514563107, -0.106796116504854, 0.0388349514563107, 0.0388349514563107, -0.0388349514563107, 0.106796116504854, -0.106796116504854, 0.0388349514563107, -0.0388349514563107, -0.0388349514563107, 0.106796116504854, -0.0388349514563107, -0.0388349514563107, 0.0388349514563107, -0.106796116504854, 0.106796116504854, 0.0388349514563107, -0.0388349514563107, 0.0388349514563107, 0.106796116504854, -0.0388349514563107, 0.0388349514563107, 0.0388349514563107, -0.106796116504854, -0.106796116504854, -0.0388349514563107, -0.0388349514563107, -0.0388349514563107, -0.106796116504854, -0.0388349514563107, -0.0388349514563107, -0.0388349514563107, -0.106796116504854, 0.106796116504854, -0.0388349514563107, -0.0388349514563107, 0.0388349514563107, -0.106796116504854, -0.0388349514563107, 0.0388349514563107, -0.0388349514563107, -0.106796116504854};
    }

    private static class Contribution3 {
        public double dx;
        public double dy;
        public double dz;
        public int xsb;
        public int ysb;
        public int zsb;
        public Contribution3 next;

        public Contribution3(double multiplier, int xsb, int ysb, int zsb) {
            this.dx = (double)(-xsb) - multiplier * 0.3333333333333333;
            this.dy = (double)(-ysb) - multiplier * 0.3333333333333333;
            this.dz = (double)(-zsb) - multiplier * 0.3333333333333333;
            this.xsb = xsb;
            this.ysb = ysb;
            this.zsb = zsb;
        }
    }
}

