/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;
import rwg.util.SnowheightCalculator;

public class SurfacePolar
extends SurfaceBase {
    public SurfacePolar(Block top, Block fill) {
        super(top, fill);
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        boolean water = false;
        boolean riverPaint = false;
        boolean grass = false;
        if (river > 0.05f && river + perlin.noise2((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
            riverPaint = true;
            if (perlin.noise2((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                grass = true;
            }
        }
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b == Blocks.field_150348_b) {
                ++depth;
                if (riverPaint) {
                    if (grass && depth < 4) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        continue;
                    }
                    if (depth != 0) continue;
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(2) == 0 ? Blocks.field_150348_b : Blocks.field_150347_e;
                    continue;
                }
                if (depth <= -1 || depth >= 9) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                if (depth != 0 || k <= 61 || k >= 254) continue;
                SnowheightCalculator.calc(x, y, k, blocks, metadata, noise);
                continue;
            }
            if (water || b != Blocks.field_150355_j) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150432_aD;
            water = true;
        }
    }
}

