/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class SurfaceMountainStone
extends SurfaceBase {
    private boolean beach;
    private Block beachBlock;
    private float min;
    private float sCliff = 1.5f;
    private float sHeight = 60.0f;
    private float sStrength = 65.0f;
    private float cCliff = 1.5f;
    public byte topByte = 0;

    public SurfaceMountainStone(Block top, Block fill, boolean genBeach, Block genBeachBlock, float minCliff) {
        super(top, fill);
        this.beach = genBeach;
        this.beachBlock = genBeachBlock;
        this.min = minCliff;
    }

    public SurfaceMountainStone(Block top, Block fill, boolean genBeach, Block genBeachBlock, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff) {
        this(top, fill, genBeach, genBeachBlock, minCliff);
        this.sCliff = stoneCliff;
        this.sHeight = stoneHeight;
        this.sStrength = stoneStrength;
        this.cCliff = clayCliff;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63 && this.beach) {
                    gravel = true;
                }
                float p = perlin.noise3((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                    cliff = 1;
                }
                if (c > this.cCliff) {
                    cliff = 2;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (k < 63) {
                    if (this.beach) {
                        blocks[(y * 16 + x) * 256 + k] = this.beachBlock;
                        gravel = true;
                        continue;
                    }
                    if (k < 62) {
                        blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.topByte;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                metadata[(y * 16 + x) * 256 + k] = this.topByte;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = gravel ? this.beachBlock : this.fillerBlock;
        }
    }
}

