/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class SurfaceCanyon
extends SurfaceBase {
    private int[] claycolor = new int[100];
    private byte blockByte = 0;
    private int grassRaise = 0;

    public SurfaceCanyon(Block top, Block fill, byte b, int grassHeight) {
        super(top, fill);
        this.blockByte = b;
        this.grassRaise = grassHeight;
        int[] c = new int[]{1, 8, 0};
        PerlinNoise perlin = new PerlinNoise(2L);
        for (int i = 0; i < 100; ++i) {
            float n = perlin.noise1((float)i / 3.0f) * 3.0f + perlin.noise1((float)i / 1.0f) * 0.3f + 1.5f;
            n = n >= 3.0f ? 2.9f : (n < 0.0f ? 0.0f : n);
            this.claycolor[i] = c[(int)n];
        }
    }

    public byte getClayColorForHeight(int k) {
        k = (k -= 60) < 0 ? 0 : (k > 99 ? 99 : k);
        return (byte)this.claycolor[k];
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.3f;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth > -1 && depth < 12) {
                if (cliff) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
                    continue;
                }
                if (depth > 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (rand.nextInt(5) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        continue;
                    }
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                    continue;
                }
                if (k < 62) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    continue;
                }
                if (k < 62 + this.grassRaise) {
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                    continue;
                }
                if (k < 75 + this.grassRaise) {
                    if (depth == 0) {
                        int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                        if (rand.nextInt(r + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                            continue;
                        }
                        if (rand.nextInt((int)((float)r / 2.0f) + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                            continue;
                        }
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                    continue;
                }
                if (depth == 0) {
                    blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                metadata[(y * 16 + x) * 256 + k] = this.blockByte;
                continue;
            }
            if (k <= 63) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
            metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
        }
    }
}

