/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.land;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceMountainStoneMix1;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainHilly;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeTestRiver
extends RealisticBiomeBase {
    private CellNoise celltest = new CellNoise(0L, 0);
    private TerrainBase terrain = new TerrainHilly(230.0f, 120.0f, 0.0f);
    private SurfaceBase surface = new SurfaceMountainStoneMix1((Block)Blocks.field_150349_c, Blocks.field_150346_d, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150348_b, 0.08f);

    public RealisticBiomeTestRiver() {
        super(0, RWGBiomes.baseHotPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return 64.1f;
    }

    public float generateNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float river) {
        float h = perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        h += perlin.noise2((float)x / 7.0f, (float)y / 7.0f) * 0.8f;
        float m = perlin.noise2((float)x / 230.0f, (float)y / 230.0f) * 120.0f * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = cell.noise((float)x / 30.0f, (float)y / 30.0f, 1.0) * (5.0f + st);
        float sm = perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f + perlin.noise2((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        float l = perlin.noise2((float)x / 260.0f, (float)y / 260.0f) * 0.0f;
        l *= l / 25.0f;
        l = l < -8.0f ? -8.0f : l;
        return 67.0f + h + (m += c) - l;
    }
}

