/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.land;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.trees.DecoJungleSmall;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceGrassCanyon;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainCanyon;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeJungleCanyon
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainCanyon(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f);
    private SurfaceBase surface = new SurfaceGrassCanyon((Block)Blocks.field_150349_c, Blocks.field_150346_d, 0);

    public RealisticBiomeJungleCanyon() {
        super(0, RWGBiomes.baseHotForest);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        int l = 0;
        while ((float)l < 1.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 70) {
                new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        int a = 0;
        while ((float)a < 5.0f * strength) {
            int j6 = chunkX + rand.nextInt(16) + 8;
            int k10 = chunkY + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10);
            DecoJungleSmall worldgenerator = new DecoJungleSmall(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 1 + rand.nextInt(4), 0, 5.0f, 2, 0.32f, 0.14f);
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            ++a;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

