/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.forest;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTrees;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.DecoLog;
import rwg.deco.DecoWildWheat;
import rwg.deco.trees.DecoBigTree;
import rwg.deco.trees.DecoShrub;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceMountainStone;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainHilly;
import rwg.util.CellNoise;
import rwg.util.PerlinNoise;

public class RealisticBiomeWoodHills
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainHilly(230.0f, 120.0f, 0.0f);
    private SurfaceBase surface = new SurfaceMountainStone((Block)Blocks.field_150349_c, Blocks.field_150346_d, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f);

    public RealisticBiomeWoodHills() {
        super(0, RWGBiomes.baseTemperateForest, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverTemperate);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength, float river) {
        float l = perlin.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 20.0f;
        l = l > 10.0f ? 10.0f : l;
        int b2 = 0;
        while ((float)b2 < strength * l) {
            int k10;
            int j6 = chunkX + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
            if (z52 < 120) {
                DecoBigTree worldgenerator = rand.nextInt(10) == 0 ? new DecoBigTree() : (rand.nextInt(6) != 0 ? new WorldGenTrees(false) : new WorldGenForest(false, false));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            ++b2;
        }
        if (l > -1.0f) {
            int z22;
            int x22;
            int y22;
            if (rand.nextInt((int)(4.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
                new DecoLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
            }
            int f24 = 0;
            while ((float)f24 < 3.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 110) {
                    new DecoShrub(rand.nextInt(4) + 1, 0, rand.nextInt(3)).func_76484_a(world, rand, i1, k1, j1);
                }
                ++f24;
            }
        }
        if (rand.nextInt((int)(150.0f / strength)) == 0) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = rand.nextInt(60) + 60;
            int k24 = chunkY + rand.nextInt(16) + 8;
            new DecoWildWheat(rand.nextInt(3)).func_76484_a(world, rand, k21, j23, k24);
        }
        if (rand.nextInt((int)(15.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(100);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int f23 = 0;
        while ((float)f23 < 8.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

