/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.util.MathHelper;

public class ParticleLogicApproachPoint
extends ParticleLogic {
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double approachSpeed;
    protected double targetDistance;
    protected boolean ignoreY;

    public ParticleLogicApproachPoint(Vector3 point, double approachSpeed, double targetDistance) {
        this.targetX = point.x;
        this.targetY = point.y;
        this.targetZ = point.z;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    private double getDistanceSqToPoint(double x, double y, double z) {
        double var2 = this.particle.field_70165_t - x;
        double var4 = this.particle.field_70163_u - y;
        double var6 = this.particle.field_70161_v - z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public ParticleLogicApproachPoint setIgnoreY(boolean ignore) {
        this.ignoreY = ignore;
        return this;
    }

    @Override
    public void doUpdate() {
        double posX = this.particle.field_70165_t;
        double posZ = this.particle.field_70161_v;
        double posY = this.particle.field_70163_u;
        double distanceToTarget = this.getDistanceSqToPoint(this.targetX, this.targetY, this.targetZ);
        double deltaZ = this.targetZ - this.particle.field_70161_v;
        double deltaX = this.targetX - this.particle.field_70165_t;
        if (Math.abs(deltaX) > this.targetDistance || Math.abs(deltaZ) > this.targetDistance) {
            double angle;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            posX = this.particle.field_70165_t + this.approachSpeed * Math.cos(radians);
            posZ = this.particle.field_70161_v + this.approachSpeed * Math.sin(radians);
        }
        if (!this.ignoreY) {
            double deltaY = posY - this.targetY;
            double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
            double pitchRadians = pitchRotation;
            posY = this.particle.field_70163_u + this.approachSpeed * Math.sin(pitchRadians);
        }
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.onDestinationReached();
        } else {
            this.particle.func_70107_b(posX, posY, posZ);
        }
    }

    public void onDestinationReached() {
        this.finishLogic();
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachPoint(new Vector3(this.targetX, this.targetY, this.targetZ), this.approachSpeed, this.targetDistance).setIgnoreY(this.ignoreY).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

