/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FacePlacementGrid;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.ControlPanelRenderer;
import gcewing.projectblue.IBlockHighlighting;
import gcewing.projectblue.ItemMultiPartJ;
import gcewing.projectblue.Trans3;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public class ControlPanelItem
extends ItemMultiPartJ
implements IBlockHighlighting {
    public static String getMaterial(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack != null && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("mat")) {
            return nbt.func_74779_i("mat");
        }
        return "tile.wood";
    }

    @Override
    public TMultiPart newPart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int sideHit, Vector3 vhit) {
        return this.newPart(stack, player, sideHit, vhit);
    }

    ControlPanelPart newPart(ItemStack stack, EntityPlayer player, int sideHit, Vector3 vhit) {
        String material = ControlPanelItem.getMaterial(stack);
        int slot = FacePlacementGrid.getHitSlot((Vector3)vhit, (int)sideHit);
        ControlPanelPart part = new ControlPanelPart(material, slot, stack.func_77978_p());
        part.rot = Trans3.turnFor((Entity)player, slot);
        if (slot == (sideHit ^ 1)) {
            part.setSurfaceMounting();
        } else {
            part.setFlushMounting();
            if (slot <= 1) {
                part.rot ^= 2;
            }
        }
        return part;
    }

    public int func_94901_k() {
        return 0;
    }

    public String func_111208_A() {
        return "controlPanelPartDoesNotHaveAnIcon";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        ControlPanelRenderer.registerIcons(reg);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List result) {
        result.add(ControlPanelMaterial.forName("tile.wood").newStack());
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        ControlPanelMaterial base = ControlPanelMaterial.forName(ControlPanelItem.getMaterial(stack));
        String uln = base.block.func_149739_a() + ".name";
        list.add("Made from " + StatCollector.func_74838_a((String)uln));
    }

    @Override
    public boolean renderHighlight(DrawBlockHighlightEvent e) {
        ItemStack stack = e.currentItem;
        EntityPlayer player = e.player;
        World world = e.player.field_70170_p;
        BlockCoord pos = new BlockCoord(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d);
        int sideHit = e.target.field_72310_e;
        Vec3 h = e.target.field_72307_f;
        Vector3 vhit = new Vector3(h.field_72450_a - (double)pos.x, h.field_72448_b - (double)pos.y, h.field_72449_c - (double)pos.z);
        pos.offset(sideHit);
        ControlPanelPart part = this.newPart(stack, player, sideHit, vhit);
        if (TileMultipart.canPlacePart((World)world, (BlockCoord)pos, (TMultiPart)part)) {
            return ControlPanelRenderer.instance.renderHighlight(part, e, pos);
        }
        return false;
    }
}

