/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.Vector3;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class PBTexture {
    public ResourceLocation location;
    public IIcon icon;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive = false;

    public PBTexture(PBTexture base) {
        this(base.icon);
        this.location = base.location;
    }

    public PBTexture(IIcon icon) {
        this.icon = icon;
    }

    public PBTexture tinted(int hex) {
        return this.tinted((double)(hex >> 16 & 0xFF) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public PBTexture tinted(double red, double green, double blue) {
        PBTexture t = new PBTexture(this);
        t.red = red;
        t.green = green;
        t.blue = blue;
        return t;
    }

    public PBTexture emissive(int hex) {
        return this.emissive((double)(hex >> 16 & 0xFF) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public PBTexture emissive(double red, double green, double blue) {
        PBTexture t = this.tinted(red, green, blue);
        t.isEmissive = true;
        return t;
    }

    public void activate(IPBRenderer pbr) {
        if (this.location != null) {
            pbr.bindTexture(this.location);
        }
        pbr.setColor(this.red, this.green, this.blue);
        pbr.setEmissive(this.isEmissive);
    }

    public void renderVertex(IPBRenderer pbr, int i, Vector3 p, Vector3 n, double u, double v) {
        pbr.renderVertex(i, p, n, this.interpolateU(u), this.interpolateV(v));
    }

    double interpolateU(double u) {
        double u0 = this.icon.func_94209_e();
        double u1 = this.icon.func_94212_f();
        return u0 + u * (u1 - u0);
    }

    double interpolateV(double v) {
        double v0 = this.icon.func_94206_g();
        double v1 = this.icon.func_94210_h();
        return v0 + v * (v1 - v0);
    }
}

