/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue.mfr;

import gcewing.projectblue.BaseTileEntity;
import gcewing.projectblue.mfr.MFRIntegration;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.nbt.NBTTagCompound;

public class RednetAdaptorTE
extends BaseTileEntity
implements IBundledTile,
IBundledEmitter {
    public static final int DIRECTION_BIT = 1;
    public static final int CONNECTED_BIT = 2;
    public static final int BUNDLED_TO_REDNET = 0;
    public static final int REDNET_TO_BUNDLED = 1;
    byte[] bundledInput = new byte[16];
    byte[] bundledOutput = new byte[16];
    int[] rednetInput = new int[16];
    int[] rednetOutput = new int[16];
    int[] signalConfig = new int[16];

    public RednetAdaptorTE() {
        for (int i = 0; i < 8; ++i) {
            this.signalConfig[i] = 2;
            this.signalConfig[8 + i] = 3;
        }
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b("bundledInput")) {
            this.bundledInput = nBTTagCompound.func_74770_j("bundledInput");
            this.bundledOutput = nBTTagCompound.func_74770_j("bundledOutput");
            this.rednetInput = nBTTagCompound.func_74759_k("rednetInput");
            this.rednetOutput = nBTTagCompound.func_74759_k("rednetOutput");
            this.signalConfig = nBTTagCompound.func_74759_k("signalConfig");
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74773_a("bundledInput", this.bundledInput);
        nBTTagCompound.func_74773_a("bundledOutput", this.bundledOutput);
        nBTTagCompound.func_74783_a("rednetInput", this.rednetInput);
        nBTTagCompound.func_74783_a("rednetOutput", this.rednetOutput);
        nBTTagCompound.func_74783_a("signalConfig", this.signalConfig);
    }

    public void toggleSignalDirection(int n) {
        int n2 = this.signalConfig[n];
        if ((n2 & 2) == 0) {
            this.setSignalConfig(n, n2 | 2);
        } else {
            this.setSignalConfig(n, n2 ^ 1);
        }
    }

    public void toggleSignalConnected(int n) {
        this.setSignalConfig(n, this.signalConfig[n] ^ 2);
    }

    public void setSignalConfig(int n, int n2) {
        this.signalConfig[n] = n2;
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void onNeighborBlockChange() {
        int n;
        byte[] byArray = new byte[16];
        boolean bl = false;
        for (n = 0; n < 6; ++n) {
            byte[] byArray2 = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, n);
            if (byArray2 == null) continue;
            for (int i = 0; i < 16; ++i) {
                byte by = byArray2[i];
                if ((by & 0xFF) <= (byArray[i] & 0xFF)) continue;
                byArray[i] = by;
            }
        }
        for (n = 0; n < 16; ++n) {
            if (this.bundledInput[n] == byArray[n]) continue;
            this.bundledInput[n] = byArray[n];
            bl = true;
        }
        if (bl) {
            this.transferSignals();
        }
        this.notifyNeighbours();
    }

    public void onRednetInputsChanged(int[] nArray) {
        for (int i = 0; i < 16; ++i) {
            this.rednetInput[i] = nArray[i];
        }
        this.transferSignals();
        this.notifyNeighbours();
    }

    void transferSignals() {
        block4: for (int i = 0; i < 16; ++i) {
            switch (this.signalConfig[i]) {
                case 2: {
                    this.rednetOutput[i] = this.bundledInput[i] != 0 ? 15 : 0;
                    continue block4;
                }
                case 3: {
                    this.bundledOutput[i] = (byte)(this.rednetInput[i] != 0 ? 255 : 0);
                    continue block4;
                }
                default: {
                    this.rednetOutput[i] = 0;
                    this.bundledOutput[i] = 0;
                }
            }
        }
        this.func_70296_d();
    }

    void notifyNeighbours() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, MFRIntegration.rednetAdaptorBlock);
    }

    void dumpSignal(byte[] byArray) {
        for (byte by : byArray) {
            System.out.printf(" %02x", by & 0xFF);
        }
        System.out.printf("\n", new Object[0]);
    }

    void dumpSignal(int[] nArray) {
        for (int n : nArray) {
            System.out.printf(" %02x", n);
        }
        System.out.printf("\n", new Object[0]);
    }

    public int[] getRednetOutput() {
        return this.rednetOutput;
    }

    public boolean canConnectBundled(int n) {
        return true;
    }

    public byte[] getBundledSignal(int n) {
        return this.bundledOutput;
    }
}

