/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.Matrix3;
import gcewing.projectblue.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class Trans3 {
    public static Trans3 ident = new Trans3(Vector3.zero, Matrix3.ident, 1.0);
    public Vector3 offset;
    public Matrix3 rotation;
    public double scaling;

    Trans3(Vector3 vector3, Matrix3 matrix3, double d) {
        this.offset = vector3;
        this.rotation = matrix3;
        this.scaling = d;
    }

    Trans3(double d, double d2, double d3) {
        this(new Vector3(d, d2, d3), Matrix3.ident, 1.0);
    }

    public Trans3 translate(double d, double d2, double d3) {
        return new Trans3(this.offset.add(this.rotation.mul(d * this.scaling, d2 * this.scaling, d3 * this.scaling)), this.rotation, this.scaling);
    }

    public Trans3 rotate(Matrix3 matrix3) {
        return new Trans3(this.offset, this.rotation.mul(matrix3), this.scaling);
    }

    public Trans3 scale(double d) {
        return new Trans3(this.offset, this.rotation, this.scaling * d);
    }

    public Trans3 side(int n) {
        return this.rotate(Matrix3.sideRotations[n]);
    }

    public Trans3 turn(int n) {
        return this.rotate(Matrix3.turnRotations[n]);
    }

    public Trans3 t(Trans3 trans3) {
        return new Trans3(this.offset.add(this.rotation.mul(trans3.offset).mul(this.scaling)), this.rotation.mul(trans3.rotation), this.scaling * trans3.scaling);
    }

    public Vector3 p(double d, double d2, double d3) {
        return this.p(new Vector3(d, d2, d3));
    }

    public Vector3 p(Vector3 vector3) {
        return this.offset.add(this.rotation.mul(vector3.mul(this.scaling)));
    }

    public Vector3 ip(double d, double d2, double d3) {
        return this.ip(new Vector3(d, d2, d3));
    }

    public Vector3 ip(Vector3 vector3) {
        return this.rotation.imul(vector3.sub(this.offset)).mul(1.0 / this.scaling);
    }

    public Vector3 v(double d, double d2, double d3) {
        return this.v(new Vector3(d, d2, d3));
    }

    public Vector3 iv(double d, double d2, double d3) {
        return this.iv(new Vector3(d, d2, d3));
    }

    public Vector3 v(Vector3 vector3) {
        return this.rotation.mul(vector3.mul(this.scaling));
    }

    public Vector3 iv(Vector3 vector3) {
        return this.rotation.imul(vector3).mul(1.0 / this.scaling);
    }

    public AxisAlignedBB t(AxisAlignedBB axisAlignedBB) {
        return Trans3.boxEnclosing(this.p(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c), this.p(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f));
    }

    public AxisAlignedBB box(Vector3 vector3, Vector3 vector32) {
        return Trans3.boxEnclosing(this.p(vector3), this.p(vector32));
    }

    public static int turnFor(Entity entity, int n) {
        if (n > 1) {
            return 0;
        }
        int n2 = Math.round(entity.field_70177_z / 90.0f);
        n2 = n == 0 ? 2 - n2 : 2 + n2;
        return n2 & 3;
    }

    static AxisAlignedBB boxEnclosing(Vector3 vector3, Vector3 vector32) {
        return AxisAlignedBB.func_72330_a((double)Math.min(vector3.x, vector32.x), (double)Math.min(vector3.y, vector32.y), (double)Math.min(vector3.z, vector32.z), (double)Math.max(vector3.x, vector32.x), (double)Math.max(vector3.y, vector32.y), (double)Math.max(vector3.z, vector32.z));
    }

    public static ForgeDirection forgeDirection(double d, double d2, double d3) {
        if (d2 < -0.5) {
            return ForgeDirection.DOWN;
        }
        if (d2 > 0.5) {
            return ForgeDirection.UP;
        }
        if (d < -0.5) {
            return ForgeDirection.WEST;
        }
        if (d > 0.5) {
            return ForgeDirection.EAST;
        }
        if (d3 < -0.5) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection forgeDirection(Vector3 vector3) {
        return Trans3.forgeDirection(vector3.x, vector3.y, vector3.z);
    }

    public ForgeDirection t(ForgeDirection forgeDirection) {
        Vector3 vector3 = this.v(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
        ForgeDirection forgeDirection2 = Trans3.forgeDirection(vector3);
        return forgeDirection2;
    }

    public ForgeDirection it(ForgeDirection forgeDirection) {
        return Trans3.forgeDirection(this.iv(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ));
    }
}

