/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.multipart.TMultiPart;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gcewing.projectblue.BaseModClient;
import gcewing.projectblue.ControlItemRenderer;
import gcewing.projectblue.ControlPanelItemRenderer;
import gcewing.projectblue.ControlPanelLabelScreen;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.ControlPanelRenderer;
import gcewing.projectblue.IBlockHighlighting;
import gcewing.projectblue.PBFacePart;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.ProjectBlueChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;

public class ProjectBlueClient
extends BaseModClient<ProjectBlue> {
    public ProjectBlueClient(ProjectBlue projectBlue) {
        super(projectBlue);
        MinecraftForge.EVENT_BUS.register((Object)this);
        projectBlue.integrateWith("NotEnoughItems", "gcewing.projectblue.nei.NEIIntegration");
    }

    @Override
    void registerBlockIcons(IIconRegister iIconRegister) {
    }

    @Override
    void registerScreens() {
    }

    @Override
    void registerRenderers() {
        ControlPanelRenderer.init();
        PBFacePart.FaceItem.registerRenderers(this);
        this.addItemRenderer(ProjectBlue.controlPanelItem, (IItemRenderer)new ControlPanelItemRenderer());
        this.addItemRenderer(ProjectBlue.miniatureLever, (IItemRenderer)new ControlItemRenderer());
        this.addItemRenderer(ProjectBlue.miniatureButton, (IItemRenderer)new ControlItemRenderer());
        this.addItemRenderer(ProjectBlue.miniatureLamp, (IItemRenderer)new ControlItemRenderer());
        this.addItemRenderer(ProjectBlue.miniatureCover, (IItemRenderer)new ControlItemRenderer());
    }

    @SubscribeEvent
    public void drawBlockHighlight(DrawBlockHighlightEvent drawBlockHighlightEvent) {
        Item item;
        if (drawBlockHighlightEvent.currentItem != null && drawBlockHighlightEvent.target != null && drawBlockHighlightEvent.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (item = drawBlockHighlightEvent.currentItem.func_77973_b()) instanceof IBlockHighlighting && ((IBlockHighlighting)item).renderHighlight(drawBlockHighlightEvent)) {
            drawBlockHighlightEvent.setCanceled(true);
        }
    }

    public void onReceiveFromServer(ProjectBlueChannel.Message message, NBTTagCompound nBTTagCompound) {
        switch (message) {
            case EDIT_CONTROL_PANEL_TEXT: {
                this.onReceiveEditControlPanelText(nBTTagCompound);
            }
        }
    }

    void onReceiveEditControlPanelText(NBTTagCompound nBTTagCompound) {
        System.out.printf("ProjectBlueChannel.onReceiveEditControlPanelText: %s\n", nBTTagCompound);
        TMultiPart tMultiPart = this.getClientPart(nBTTagCompound);
        System.out.printf("ProjectBlueChannel.onReceiveEditControlPanelText: part = %s\n", tMultiPart);
        if (tMultiPart instanceof ControlPanelPart) {
            int n = nBTTagCompound.func_74762_e("cell");
            ProjectBlueClient.openClientGui(new ControlPanelLabelScreen((ControlPanelPart)tMultiPart, n));
        }
    }

    TMultiPart getClientPart(NBTTagCompound nBTTagCompound) {
        return ProjectBlueChannel.getPart(nBTTagCompound, (World)Minecraft.func_71410_x().field_71441_e);
    }
}

