/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.multipart.MultiPartRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.projectblue.BaseDataChannel;
import gcewing.projectblue.BaseMod;
import gcewing.projectblue.ControlItem;
import gcewing.projectblue.ControlPanelItem;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.ControlPanelRecipes;
import gcewing.projectblue.PBFacePart;
import gcewing.projectblue.PBModel;
import gcewing.projectblue.PBTexture;
import gcewing.projectblue.ProjectBlueChannel;
import gcewing.projectblue.ProjectBlueClient;
import gcewing.projectblue.SprayCanItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

@Mod(modid="ProjectBlue", name="Project Blue", version="1.1.6", acceptableRemoteVersions="[1.1,1.2)")
public class ProjectBlue
extends BaseMod<ProjectBlueClient> {
    public static ProjectBlue mod;
    public static Item controlPanelItem;
    public static Item miniatureLever;
    public static Item miniatureButton;
    public static Item miniatureLamp;
    public static Item miniatureCover;
    public static Item emptySprayCan;
    public static SprayCanItem sprayCan;
    public static Item itemPartFixture;
    public static Item itemMicroPart;
    public static Item itemStoneSaw;
    public static ItemStack stackStoneSaw;
    public static ProjectBlueChannel channel;
    public static BaseDataChannel dataChannel;

    public static PBModel getModel(String string) {
        return PBModel.fromResource(mod.resourceLocation("models/" + string + ".json"));
    }

    public ProjectBlue() {
        mod = this;
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        System.out.printf("ProjectBlue.preInit\n", new Object[0]);
        this.integrateWith("MineFactoryReloaded", "gcewing.projectblue.mfr.MFRIntegration");
        super.preInit(fMLPreInitializationEvent);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        System.out.printf("ProjectBlue.init\n", new Object[0]);
        super.init(fMLInitializationEvent);
        this.configure();
        this.registerMultiParts();
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        System.out.printf("ProjectBlue.postInit\n", new Object[0]);
        super.postInit(fMLPostInitializationEvent);
        channel = new ProjectBlueChannel("gce.projectblue");
        dataChannel = new BaseDataChannel("projectblue.data", this, this.client);
        itemPartFixture = this.findItem("ProjRed|Illumination", "projectred.illumination.fixture");
        itemMicroPart = this.findItem("ForgeMicroblock", "microblock");
        itemStoneSaw = this.findItem("ForgeMicroblock", "sawStone");
        stackStoneSaw = new ItemStack(itemStoneSaw);
    }

    Item findItem(String string, String string2) {
        Item item = GameRegistry.findItem((String)string, (String)string2);
        if (item == null) {
            throw new RuntimeException("Can't find item " + string + ":" + string2);
        }
        return item;
    }

    @Override
    ProjectBlueClient initClient() {
        return new ProjectBlueClient(this);
    }

    @Override
    void configure() {
    }

    @Override
    protected void registerBlocks() {
    }

    void registerMultiParts() {
        ProjectBlue.addMultiPart(new ControlPanelPart.Factory(), "pb_controlpanel");
    }

    @Override
    protected void registerItems() {
        System.out.printf("ProjectBlue.registerItems\n", new Object[0]);
        controlPanelItem = this.addItem(new ControlPanelItem(), "controlPanel");
        miniatureLever = this.addItem(new ControlItem(ControlPanelPart.ControlType.LEVER), "miniatureLever");
        miniatureButton = this.addItem(new ControlItem(ControlPanelPart.ControlType.BUTTON), "miniatureButton");
        miniatureLamp = this.addItem(new ControlItem(ControlPanelPart.ControlType.LAMP), "miniatureLamp");
        miniatureCover = this.addItem(new ControlItem(ControlPanelPart.ControlType.BLANK), "miniatureCover");
        emptySprayCan = this.newItem("emptySprayCan");
        sprayCan = this.addItem(new SprayCanItem(), "sprayCan");
    }

    @Override
    protected void registerRecipes() {
        ControlPanelRecipes.registerRecipes();
        this.newRecipe(emptySprayCan, 4, "b", "I", "I", Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('I'), Items.field_151042_j);
        for (int i = 0; i < 16; ++i) {
            this.newShapelessRecipe(sprayCan.newStack(1, i), emptySprayCan, Items.field_151117_aB, Items.field_151110_aK, new ItemStack(Items.field_151100_aR, 1, 15 - i));
        }
    }

    @Override
    protected void registerContainers() {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTickEvent) {
        switch (serverTickEvent.phase) {
            case END: {
                this.onServerTickEnd();
            }
        }
    }

    void onServerTickEnd() {
    }

    public static void addMultiPart(MultiPartRegistry.IPartFactory iPartFactory, String ... stringArray) {
        System.out.printf("ProjectBlue.addMultiPart: using %s:", iPartFactory);
        for (String string : stringArray) {
            System.out.printf(" %s", string);
        }
        System.out.printf("\n", new Object[0]);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)iPartFactory, (String[])stringArray);
    }

    void addFacePart(Class<? extends PBFacePart> clazz, String string) {
        String string2 = "pb_" + string.toLowerCase();
        PBFacePart.Factory factory = new PBFacePart.Factory(clazz, string2);
        PBFacePart.FaceItem faceItem = new PBFacePart.FaceItem(factory);
        ProjectBlue.addMultiPart(factory, string2);
        this.addItem(faceItem, string);
    }

    public static String getColorName(ItemStack itemStack) {
        return ProjectBlue.getColorName(itemStack.func_77960_j());
    }

    public static String getColorName(int n) {
        return StatCollector.func_74838_a((String)String.format("color.gcewing_projectblue:%s", n));
    }

    @SideOnly(value=Side.CLIENT)
    public PBTexture[] getTextures(IIconRegister iIconRegister, String ... stringArray) {
        PBTexture[] pBTextureArray = new PBTexture[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pBTextureArray[i] = new PBTexture(this.getIcon(iIconRegister, stringArray[i]));
        }
        return pBTextureArray;
    }
}

