/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.PartMap;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gcewing.projectblue.PBFacePart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.libmc.PRLib;
import mrtjp.projectred.transmission.IRedwireEmitter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public abstract class PBWiredFacePart
extends PBFacePart
implements IConnectable,
IRedstonePart {
    public int connMap;

    @Override
    public void save(NBTTagCompound nBTTagCompound) {
        super.save(nBTTagCompound);
        nBTTagCompound.func_74768_a("connMap", this.connMap);
    }

    @Override
    public void load(NBTTagCompound nBTTagCompound) {
        super.load(nBTTagCompound);
        this.connMap = nBTTagCompound.func_74762_e("connMap");
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        if (!this.world().field_72995_K) {
            this.updateInternalConnections();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            this.updateExternalConnections();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().field_72995_K) {
            this.updateConnections();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            this.notifyNeighbors(15);
        }
    }

    protected void updateConnections() {
        this.updateInternalConnections();
        this.updateExternalConnections();
    }

    protected boolean updateExternalConnections() {
        int n;
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            if (this.connectStraight(n)) {
                n2 |= 16 << n;
                continue;
            }
            if (!this.connectCorner(n)) continue;
            n2 |= 1 << n;
        }
        if (n2 != (this.connMap & 0xF000FF)) {
            n = this.connMap ^ n2;
            this.connMap = this.connMap & 0xFF0FFF00 | n2;
            for (int i = 0; i < 4; ++i) {
                if ((n & 1 << i) == 0) continue;
                this.notifyCornerChange(i);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.connectInternal(i)) continue;
            n |= 256 << i;
        }
        if (n != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | n;
            return true;
        }
        return false;
    }

    public boolean connectCorner(int n) {
        TMultiPart tMultiPart;
        TileMultipart tileMultipart;
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2);
        if (!this.world().func_147437_c(blockCoord.x, blockCoord.y, blockCoord.z)) {
            int n3 = n2 ^ 1;
            int n4 = this.side;
            tileMultipart = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)blockCoord);
            if (tileMultipart != null && (tileMultipart.partMap(n3) != null || tileMultipart.partMap(n4) != null || tileMultipart.partMap(PartMap.edgeBetween((int)n3, (int)n4)) != null)) {
                return false;
            }
        }
        blockCoord.offset(this.side);
        TileMultipart tileMultipart2 = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart2 != null && (tMultiPart = tileMultipart2.partMap(n2 ^ 1)) instanceof IConnectable) {
            tileMultipart = (IConnectable)tMultiPart;
            int n5 = Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side ^ 1));
            return this.canConnectToGlobal((IConnectable)tileMultipart, n) && tileMultipart.canConnectCorner(n5) && tileMultipart.connectCorner((IConnectable)this, n5, -1);
        }
        return false;
    }

    public boolean connectStraight(int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2);
        TileMultipart tileMultipart = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(this.side)) instanceof IConnectable) {
            IConnectable iConnectable = (IConnectable)tMultiPart;
            return this.canConnectToGlobal(iConnectable, n) && iConnectable.connectStraight((IConnectable)this, (n + 2) % 4, -1);
        }
        return this.connectStraightOverride(n2);
    }

    public boolean connectStraightOverride(int n) {
        return false;
    }

    public boolean connectInternal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        if (this.tile().partMap(PartMap.edgeBetween((int)n2, (int)this.side)) != null) {
            return false;
        }
        TMultiPart tMultiPart = this.tile().partMap(n2);
        if (tMultiPart instanceof IConnectable) {
            IConnectable iConnectable = (IConnectable)tMultiPart;
            return this.canConnectToGlobal(iConnectable, n) && iConnectable.connectInternal((IConnectable)this, Rotation.rotationTo((int)n2, (int)this.side));
        }
        return false;
    }

    public void notifyCornerChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2).offset(this.side);
        this.world().func_147460_e(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().func_145838_q());
    }

    public void notifyStraightChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2);
        this.world().func_147460_e(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().func_145838_q());
    }

    public void notifyNeighbors(int n) {
        for (int i = 0; i < 4; ++i) {
            if ((n & 1 << i) != 0) {
                this.notifyCornerChange(i);
                continue;
            }
            if ((n & 16 << i) == 0) continue;
            this.notifyStraightChange(i);
        }
    }

    public boolean connectCorner(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectToGlobal(iConnectable, n)) {
            this.connMap |= 1 << n;
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectToGlobal(iConnectable, n)) {
            this.connMap |= 16 << n;
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable iConnectable, int n) {
        if (n < 0) {
            return false;
        }
        if (this.canConnectToGlobal(iConnectable, n)) {
            this.connMap |= 256 << n;
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int n) {
        return false;
    }

    public boolean canConnectToGlobal(IConnectable iConnectable, int n) {
        return this.canConnectTo(iConnectable, this.localEdge(n));
    }

    public int localEdge(int n) {
        return n + this.rot & 3;
    }

    public int globalEdge(int n) {
        return n - this.rot & 3;
    }

    public boolean canConnectTo(IConnectable iConnectable, int n) {
        if (iConnectable instanceof IRedwireEmitter) {
            return this.canConnectToRedstone(n);
        }
        return false;
    }

    public int strongPowerLevel(int n) {
        return 0;
    }

    public int weakPowerLevel(int n) {
        return 0;
    }

    public boolean canConnectRedstone(int n) {
        if ((n & 6) == (this.side & 6)) {
            return false;
        }
        return this.canConnectToRedstone(this.localEdgeForSide(n));
    }

    public boolean canConnectToRedstone(int n) {
        return false;
    }

    private int localEdgeForSide(int n) {
        return this.localEdge(Rotation.rotationTo((int)this.side, (int)n));
    }

    public int getAllRedstoneInputs() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.getRedstoneInput(i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getRedstoneInput(int n) {
        int n2 = this.globalEdge(n);
        if ((this.connMap & 1 << n2) != 0) {
            return this.calculateCornerSignal(n2);
        }
        if ((this.connMap & 16 << n2) != 0) {
            return this.calculateStraightSignal(n2);
        }
        if ((this.connMap & 256 << n2) != 0) {
            return this.calculateInternalSignal(n2);
        }
        return this.calculateRedstoneSignal(n2, this.requiresStrongInput(n));
    }

    public boolean requiresStrongInput(int n) {
        return false;
    }

    private int calculateRedstoneSignal(int n, boolean bl) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        int n3 = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n2) * 17;
        if (n3 > 0 || bl) {
            return n3;
        }
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2);
        if (this.world().func_147445_c(blockCoord.x, blockCoord.y, blockCoord.z, false)) {
            return this.world().func_94577_B(blockCoord.x, blockCoord.y, blockCoord.z) * 17;
        }
        return 0;
    }

    private int calculateCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2).offset(this.side);
        TileMultipart tileMultipart = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side ^ 1)));
        }
        return 0;
    }

    private int calculateStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((TileEntity)this.tile()).offset(n2);
        TileMultipart tileMultipart = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(this.side), (n + 2) % 4);
        }
        return 0;
    }

    private int calculateInternalSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        TMultiPart tMultiPart = this.tile().partMap(n2);
        int n3 = this.getPartSignal(tMultiPart, Rotation.rotationTo((int)n2, (int)this.side));
        if (n3 > 0) {
            return n3;
        }
        if (tMultiPart instanceof IRedstonePart) {
            IRedstonePart iRedstonePart = (IRedstonePart)tMultiPart;
            return Math.max(iRedstonePart.strongPowerLevel(this.side), iRedstonePart.weakPowerLevel(this.side)) << 4;
        }
        return 0;
    }

    private int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        return 0;
    }
}

