/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import com.google.gson.Gson;
import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.PBTexture;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Vector3;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PBModel {
    public double[] bounds;
    public Face[] faces;
    static Gson gson = new Gson();

    public static PBModel fromResource(ResourceLocation resourceLocation) {
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            PBModel pBModel = (PBModel)gson.fromJson((Reader)new InputStreamReader(inputStream), PBModel.class);
            pBModel.prepare();
            return pBModel;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public AxisAlignedBB getBounds() {
        return AxisAlignedBB.func_72330_a((double)this.bounds[0], (double)this.bounds[1], (double)this.bounds[2], (double)this.bounds[3], (double)this.bounds[4], (double)this.bounds[5]);
    }

    void prepare() {
        for (Face face : this.faces) {
            double[][] dArray = face.vertices;
            int[] nArray = face.triangles[0];
            face.centroid = Vector3.average(dArray[nArray[0]], dArray[nArray[1]], dArray[nArray[2]]);
            face.normal = Vector3.unit(Vector3.sub(dArray[nArray[1]], dArray[nArray[0]]).cross(Vector3.sub(dArray[nArray[2]], dArray[nArray[0]])));
        }
    }

    public void tessellate(Trans3 trans3, IIcon ... iIconArray) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Vector3 vector3 = null;
        Vector3 vector32 = null;
        double d = 0.0;
        double d2 = 0.0;
        for (Face face : this.faces) {
            IIcon iIcon = iIconArray[face.texture];
            double d3 = iIcon.func_94209_e();
            double d4 = iIcon.func_94206_g();
            double d5 = (double)iIcon.func_94212_f() - d3;
            double d6 = (double)iIcon.func_94210_h() - d4;
            int[][] nArray = face.triangles;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray2;
                for (int n2 : nArray2 = nArray[i]) {
                    double[] dArray = face.vertices[n2];
                    vector3 = trans3.p(dArray[0], dArray[1], dArray[2]);
                    vector32 = trans3.v(dArray[3], dArray[4], dArray[5]);
                    d = d3 + d5 * dArray[6];
                    d2 = d4 + d6 * dArray[7];
                    tessellator.func_78375_b((float)vector32.x, (float)vector32.y, (float)vector32.z);
                    tessellator.func_78374_a(vector3.x, vector3.y, vector3.z, d, d2);
                }
                tessellator.func_78375_b((float)vector32.x, (float)vector32.y, (float)vector32.z);
                tessellator.func_78374_a(vector3.x, vector3.y, vector3.z, d, d2);
            }
        }
    }

    public void draw(Trans3 trans3, IIcon ... iIconArray) {
        Vector3 vector3 = null;
        Vector3 vector32 = null;
        double d = 0.0;
        double d2 = 0.0;
        GL11.glBegin((int)4);
        for (Face face : this.faces) {
            IIcon iIcon = iIconArray[face.texture];
            double d3 = iIcon.func_94209_e();
            double d4 = iIcon.func_94206_g();
            double d5 = (double)iIcon.func_94212_f() - d3;
            double d6 = (double)iIcon.func_94210_h() - d4;
            int[][] nArray = face.triangles;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray2;
                for (int n2 : nArray2 = nArray[i]) {
                    double[] dArray = face.vertices[n2];
                    vector3 = trans3.p(dArray[0], dArray[1], dArray[2]);
                    vector32 = trans3.v(dArray[3], dArray[4], dArray[5]);
                    d = d3 + d5 * dArray[6];
                    d2 = d4 + d6 * dArray[7];
                    GL11.glNormal3d((double)vector32.x, (double)vector32.y, (double)vector32.z);
                    GL11.glTexCoord2d((double)d, (double)d2);
                    GL11.glVertex3d((double)vector3.x, (double)vector3.y, (double)vector3.z);
                }
            }
        }
        GL11.glEnd();
    }

    public void render(Trans3 trans3, IPBRenderer iPBRenderer, PBTexture ... pBTextureArray) {
        Vector3 vector3 = null;
        Vector3 vector32 = null;
        PBTexture pBTexture = null;
        iPBRenderer.begin(4);
        for (Face face : this.faces) {
            PBTexture pBTexture2 = pBTextureArray[face.texture];
            if (pBTexture != pBTexture2) {
                pBTexture2.activate(iPBRenderer);
                pBTexture = pBTexture2;
            }
            iPBRenderer.lightFace(trans3.p(face.centroid), trans3.v(face.normal));
            for (int[] nArray : face.triangles) {
                for (int i = 0; i < 3; ++i) {
                    int n = nArray[i];
                    double[] dArray = face.vertices[n];
                    vector3 = trans3.p(dArray[0], dArray[1], dArray[2]);
                    vector32 = trans3.v(dArray[3], dArray[4], dArray[5]);
                    pBTexture2.renderVertex(iPBRenderer, i, vector3, vector32, dArray[6], dArray[7]);
                }
            }
        }
        iPBRenderer.end();
    }

    public static class Face {
        int texture;
        double[][] vertices;
        int[][] triangles;
        Vector3 centroid;
        Vector3 normal;
    }
}

