/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.microblock.ItemSaw;
import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.projectblue.ControlItem;
import gcewing.projectblue.ControlPanelItem;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.SprayCanItem;
import gcewing.projectblue.nei.INEIRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

public class ControlPanelRecipes {
    public static final int coverMeta = 1;
    public static final int hollowCoverMeta = 257;
    public static List<RecipeBase> recipes = new ArrayList<RecipeBase>();

    public static boolean isEmpty(InventoryCrafting inventoryCrafting, int n, int n2) {
        return inventoryCrafting.func_70463_b(n, n2) == null;
    }

    public static boolean isSaw(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.isSaw(inventoryCrafting.func_70463_b(n, n2));
    }

    public static boolean isSaw(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ItemSaw;
    }

    public static boolean isHollowCover(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.isHollowCover(inventoryCrafting.func_70463_b(n, n2));
    }

    public static boolean isHollowCover(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == ProjectBlue.itemMicroPart && itemStack.func_77960_j() == 257;
    }

    public static boolean isFullSizeControl(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.miniatureStackFor(inventoryCrafting, n2, n) != null;
    }

    public static boolean isFullSizeControl(ItemStack itemStack) {
        return ControlPanelRecipes.miniatureStackFor(itemStack) != null;
    }

    public static boolean isControlPanel(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ControlPanelItem;
    }

    public static ItemStack miniatureStackFor(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.miniatureStackFor(inventoryCrafting.func_70463_b(n, n2));
    }

    public static ItemStack miniatureStackFor(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        int n = itemStack.func_77960_j();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150442_at) {
                return new ItemStack(ProjectBlue.miniatureLever, 1, 16);
            }
            if (block == Blocks.field_150430_aB) {
                return new ItemStack(ProjectBlue.miniatureButton, 1, 16);
            }
            if (block == Blocks.field_150471_bO) {
                return new ItemStack(ProjectBlue.miniatureButton, 1, 17);
            }
        }
        if (item == ProjectBlue.itemPartFixture) {
            return new ItemStack(ProjectBlue.miniatureLamp, 1, n);
        }
        if (item == ProjectBlue.itemMicroPart && n == 1) {
            return ControlPanelMaterial.forStack(itemStack).newStack(ProjectBlue.miniatureCover);
        }
        return null;
    }

    public static ItemStack fullSizeStackFor(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int n = itemStack.func_77960_j();
        if (item == ProjectBlue.miniatureLever && n == 16) {
            return new ItemStack(Blocks.field_150442_at);
        }
        if (item == ProjectBlue.miniatureButton && n == 16) {
            return new ItemStack(Blocks.field_150430_aB);
        }
        if (item == ProjectBlue.miniatureButton && n == 17) {
            return new ItemStack(Blocks.field_150471_bO);
        }
        if (item == ProjectBlue.miniatureLamp) {
            return new ItemStack(ProjectBlue.itemPartFixture, 1, n);
        }
        if (item == ProjectBlue.miniatureCover) {
            return ControlPanelMaterial.forStack(itemStack).newStack(ProjectBlue.itemMicroPart, 1);
        }
        return null;
    }

    public static String materialAt(InventoryCrafting inventoryCrafting, int n, int n2) {
        ItemStack itemStack = inventoryCrafting.func_70463_b(n, n2);
        return ControlPanelItem.getMaterial(itemStack);
    }

    static boolean isPaintableControl(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.isPaintableControl(inventoryCrafting.func_70463_b(n, n2));
    }

    static boolean isPaintableControl(ItemStack itemStack) {
        Item item;
        if (itemStack != null && (item = itemStack.func_77973_b()) instanceof ControlItem) {
            switch (((ControlItem)item).type) {
                case LEVER: 
                case BUTTON: {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isPaintedControl(ItemStack itemStack) {
        return ControlPanelRecipes.isPaintableControl(itemStack) && itemStack.func_77960_j() < 16;
    }

    static boolean isSprayCan(InventoryCrafting inventoryCrafting, int n, int n2) {
        return ControlPanelRecipes.isSprayCan(inventoryCrafting.func_70463_b(n, n2));
    }

    static boolean isSprayCan(ItemStack itemStack) {
        if (itemStack != null) {
            return itemStack.func_77973_b() instanceof SprayCanItem;
        }
        return false;
    }

    static void addRecipe(RecipeBase recipeBase) {
        recipes.add(recipeBase);
        GameRegistry.addRecipe((IRecipe)recipeBase);
    }

    public static void registerRecipes() {
        RecipeSorter.register((String)"projectblue:controlpanel", RecipeBase.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        ControlPanelRecipes.addRecipe(new CraftControlPanel());
        ControlPanelRecipes.addRecipe(new CraftMiniatureItem());
        ControlPanelRecipes.addRecipe(new PaintControl());
    }

    static class PaintControl
    extends RecipeBase {
        PaintControl() {
        }

        public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
            return ControlPanelRecipes.isPaintableControl(inventoryCrafting, 0, 0) && ControlPanelRecipes.isSprayCan(inventoryCrafting, 1, 0);
        }

        public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
            ItemStack itemStack = inventoryCrafting.func_70463_b(0, 0);
            ItemStack itemStack2 = inventoryCrafting.func_70463_b(1, 0);
            SprayCanItem sprayCanItem = (SprayCanItem)itemStack2.func_77973_b();
            return new ItemStack(itemStack.func_77973_b(), 1, sprayCanItem.getColor(itemStack2));
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            if (ControlPanelRecipes.isPaintedControl(itemStack)) {
                Item item = itemStack.func_77973_b();
                int n = itemStack.func_77960_j();
                ItemStack itemStack2 = ProjectBlue.sprayCan.newStack(1, n);
                this.addRecipeToNEI(iNEIRecipeHandler, new ItemStack(item, 1, 16), itemStack2);
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            if (ControlPanelRecipes.isSprayCan(itemStack)) {
                this.addRecipeToNEI(iNEIRecipeHandler, new ItemStack(ProjectBlue.miniatureLever, 1, 16), itemStack);
                this.addRecipeToNEI(iNEIRecipeHandler, new ItemStack(ProjectBlue.miniatureButton, 1, 16), itemStack);
                this.addRecipeToNEI(iNEIRecipeHandler, new ItemStack(ProjectBlue.miniatureButton, 1, 17), itemStack);
            } else if (ControlPanelRecipes.isPaintableControl(itemStack)) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack itemStack2 = ProjectBlue.sprayCan.newStack(1, i);
                    this.addRecipeToNEI(iNEIRecipeHandler, itemStack, itemStack2);
                }
            }
        }

        void addRecipeToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack, ItemStack itemStack2) {
            Item item = itemStack.func_77973_b();
            int n = ProjectBlue.sprayCan.getColor(itemStack2);
            ItemStack itemStack3 = new ItemStack(item, 1, n);
            iNEIRecipeHandler.addShapedRecipe(2, 1, itemStack3, itemStack, itemStack2);
        }
    }

    static class CraftMiniatureItem
    extends RecipeBase {
        CraftMiniatureItem() {
        }

        public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
            return ControlPanelRecipes.isSaw(inventoryCrafting, 0, 0) && ControlPanelRecipes.isEmpty(inventoryCrafting, 0, 1) && ControlPanelRecipes.isEmpty(inventoryCrafting, 1, 0) && ControlPanelRecipes.isFullSizeControl(inventoryCrafting, 1, 1);
        }

        public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
            ItemStack itemStack = ControlPanelRecipes.miniatureStackFor(inventoryCrafting, 1, 1);
            if (itemStack != null) {
                itemStack.field_77994_a = 8;
            }
            return itemStack;
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            ItemStack itemStack2 = ControlPanelRecipes.fullSizeStackFor(itemStack);
            if (itemStack2 != null) {
                this.addRecipeToNEI(iNEIRecipeHandler, null, itemStack2);
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            if (ControlPanelRecipes.isSaw(itemStack)) {
                ControlPanelMaterial controlPanelMaterial = ControlPanelMaterial.forName("tile.wood");
                this.addRecipeToNEI(iNEIRecipeHandler, itemStack, new ItemStack(Blocks.field_150442_at));
                this.addRecipeToNEI(iNEIRecipeHandler, itemStack, new ItemStack(Blocks.field_150430_aB));
                this.addRecipeToNEI(iNEIRecipeHandler, itemStack, new ItemStack(Blocks.field_150471_bO));
                this.addRecipeToNEI(iNEIRecipeHandler, itemStack, controlPanelMaterial.newStack(ProjectBlue.itemMicroPart, 1));
                for (int i = 0; i < 16; ++i) {
                    this.addRecipeToNEI(iNEIRecipeHandler, itemStack, new ItemStack(ProjectBlue.itemPartFixture, 1, i));
                }
            } else if (ControlPanelRecipes.isFullSizeControl(itemStack)) {
                this.addRecipeToNEI(iNEIRecipeHandler, null, itemStack);
            }
        }

        void addRecipeToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack, ItemStack itemStack2) {
            if (itemStack == null) {
                itemStack = ProjectBlue.stackStoneSaw;
            }
            ItemStack itemStack3 = ControlPanelRecipes.miniatureStackFor(itemStack2);
            itemStack3.field_77994_a = 8;
            iNEIRecipeHandler.addShapedRecipe(2, 2, itemStack3, itemStack, null, null, itemStack2);
        }
    }

    static class CraftControlPanel
    extends RecipeBase {
        CraftControlPanel() {
        }

        public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
            return ControlPanelRecipes.isSaw(inventoryCrafting, 0, 0) && ControlPanelRecipes.isEmpty(inventoryCrafting, 0, 1) && ControlPanelRecipes.isEmpty(inventoryCrafting, 1, 0) && ControlPanelRecipes.isHollowCover(inventoryCrafting, 1, 1);
        }

        public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
            String string = ControlPanelRecipes.materialAt(inventoryCrafting, 1, 1);
            ControlPanelMaterial controlPanelMaterial = ControlPanelMaterial.forName(string);
            return controlPanelMaterial.newStack();
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            if (ControlPanelRecipes.isControlPanel(itemStack)) {
                this.addRecipeToNEI(iNEIRecipeHandler, null, ControlPanelMaterial.forStack(itemStack));
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
            if (ControlPanelRecipes.isSaw(itemStack)) {
                this.addRecipeToNEI(iNEIRecipeHandler, itemStack, ControlPanelMaterial.forName("tile.wood"));
            } else if (ControlPanelRecipes.isHollowCover(itemStack)) {
                this.addRecipeToNEI(iNEIRecipeHandler, null, ControlPanelMaterial.forStack(itemStack));
            }
        }

        void addRecipeToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack, ControlPanelMaterial controlPanelMaterial) {
            if (itemStack == null) {
                itemStack = ProjectBlue.stackStoneSaw;
            }
            ItemStack itemStack2 = controlPanelMaterial.newStack(ProjectBlue.itemMicroPart, 257);
            ItemStack itemStack3 = controlPanelMaterial.newStack();
            iNEIRecipeHandler.addShapedRecipe(2, 2, itemStack3, itemStack, null, null, itemStack2);
        }
    }

    public static abstract class RecipeBase
    implements IRecipe {
        public int func_77570_a() {
            return 4;
        }

        public ItemStack func_77571_b() {
            return null;
        }

        public void addCraftingToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
        }

        public void addUsageToNEI(INEIRecipeHandler iNEIRecipeHandler, ItemStack itemStack) {
        }
    }
}

