/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public class BaseNBTChannel<PACKET_TYPE extends Enum> {
    EnumMap<Side, FMLEmbeddedChannel> channels;

    public BaseNBTChannel(String string) {
        NBTCodec nBTCodec = new NBTCodec();
        this.channels = NetworkRegistry.INSTANCE.newChannel(string, new ChannelHandler[]{nBTCodec});
        for (Side side : Side.values()) {
            ChannelPipeline channelPipeline = this.channels.get(side).pipeline();
            channelPipeline.removeLast();
            channelPipeline.addLast(new ChannelHandler[]{new NBTHandler(this, side)});
        }
    }

    void onReceiveFromClient(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound, EntityPlayer entityPlayer) {
    }

    void onReceiveFromServer(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound) {
    }

    void sendToTarget(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound, Side side, FMLOutboundHandler.OutboundTarget outboundTarget, Object ... objectArray) {
        FMLEmbeddedChannel fMLEmbeddedChannel = this.channels.get(side);
        NBTMessage nBTMessage = new NBTMessage();
        nBTMessage.type = PACKET_TYPE;
        nBTMessage.nbt = nBTTagCompound;
        fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)outboundTarget);
        if (objectArray.length == 1) {
            fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(objectArray[0]);
        }
        fMLEmbeddedChannel.writeAndFlush(nBTMessage).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound) {
        this.sendToTarget(PACKET_TYPE, nBTTagCompound, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER, new Object[0]);
    }

    public void sendToPlayer(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound, EntityPlayer entityPlayer) {
        this.sendToTarget(PACKET_TYPE, nBTTagCompound, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, entityPlayer);
    }

    public void sendToAllPlayers(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound) {
        this.sendToTarget(PACKET_TYPE, nBTTagCompound, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALL, new Object[0]);
    }

    public void sendToAllAround(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound, NetworkRegistry.TargetPoint targetPoint) {
        this.sendToTarget(PACKET_TYPE, nBTTagCompound, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, targetPoint);
    }

    public void sendToDimension(PACKET_TYPE PACKET_TYPE, NBTTagCompound nBTTagCompound, int n) {
        this.sendToTarget(PACKET_TYPE, nBTTagCompound, Side.SERVER, FMLOutboundHandler.OutboundTarget.DIMENSION, n);
    }

    static class NBTHandler<PACKET_TYPE extends Enum>
    extends ChannelInboundHandlerAdapter {
        BaseNBTChannel<PACKET_TYPE> client;
        Side side;

        NBTHandler(BaseNBTChannel<PACKET_TYPE> baseNBTChannel, Side side) {
            this.client = baseNBTChannel;
            this.side = side;
        }

        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof NBTMessage) {
                NBTMessage nBTMessage = (NBTMessage)object;
                switch (this.side) {
                    case SERVER: {
                        INetHandler iNetHandler = (INetHandler)channelHandlerContext.channel().attr(NetworkRegistry.NET_HANDLER).get();
                        EntityPlayerMP entityPlayerMP = ((NetHandlerPlayServer)iNetHandler).field_147369_b;
                        this.client.onReceiveFromClient(nBTMessage.type, nBTMessage.nbt, (EntityPlayer)entityPlayerMP);
                        break;
                    }
                    case CLIENT: {
                        this.client.onReceiveFromServer(nBTMessage.type, nBTMessage.nbt);
                    }
                }
            }
        }
    }

    static class NBTCodec<PACKET_TYPE extends Enum>
    extends FMLIndexedMessageToMessageCodec<NBTMessage<PACKET_TYPE>> {
        NBTCodec() {
            this.addDiscriminator(0, NBTMessage.class);
        }

        public void encodeInto(ChannelHandlerContext channelHandlerContext, NBTMessage<PACKET_TYPE> nBTMessage, ByteBuf byteBuf) throws Exception {
            ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(byteBuf);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteBufOutputStream);
            objectOutputStream.writeObject(nBTMessage.type);
            CompressedStreamTools.func_74800_a((NBTTagCompound)nBTMessage.nbt, (DataOutput)objectOutputStream);
            objectOutputStream.close();
        }

        public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, NBTMessage<PACKET_TYPE> nBTMessage) {
            ByteBufInputStream byteBufInputStream = new ByteBufInputStream(byteBuf);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)byteBufInputStream);
                nBTMessage.type = (Enum)objectInputStream.readObject();
                nBTMessage.nbt = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(objectInputStream));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class NBTMessage<PACKET_TYPE extends Enum> {
        public PACKET_TYPE type;
        public NBTTagCompound nbt;
    }
}

