/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.projectblue.BaseIntegration;
import gcewing.projectblue.BaseMod;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    static Map<String, BRBinding> blockRenderers = new HashMap<String, BRBinding>();
    MOD base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();

    public BaseModClient(MOD MOD) {
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.registerScreens();
        this.registerRenderers();
        this.registerOther();
        for (BaseIntegration baseIntegration : ((BaseMod)this.base).integrations) {
            baseIntegration.registerScreens();
            baseIntegration.registerRenderers();
            baseIntegration.registerOtherClient();
        }
        this.registerImplicitBlockRenderers();
        this.registerSavedVillagerSkins();
    }

    void registerImplicitBlockRenderers() {
        for (BaseMod.IBlock iBlock : ((BaseMod)this.base).registeredBlocks) {
            BRBinding bRBinding;
            String string = iBlock.getQualifiedRendererClassName();
            if (string == null || (bRBinding = this.getBlockRendererForName(string)) == null) continue;
            iBlock.setRenderType(bRBinding.id);
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : ((BaseMod)this.base).registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    BRBinding getBlockRendererForName(String string) {
        BRBinding bRBinding = blockRenderers.get(string);
        if (bRBinding == null) {
            ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler;
            String string2;
            Class<?> clazz = null;
            int n = string.lastIndexOf(".");
            String string3 = string2 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            while (clazz == null) {
                try {
                    clazz = Class.forName(string3 + "." + string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n = string3.lastIndexOf(".");
                    if (n < 0) {
                        throw new RuntimeException(String.format("Block renderer class %s not found in %s or containing packages", string4, string2));
                    }
                    string3 = string3.substring(0, n);
                }
            }
            try {
                iSimpleBlockRenderingHandler = (ISimpleBlockRenderingHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            bRBinding = new BRBinding();
            bRBinding.id = RenderingRegistry.getNextAvailableRenderId();
            bRBinding.object = iSimpleBlockRenderingHandler;
            RenderingRegistry.registerBlockHandler((int)bRBinding.id, (ISimpleBlockRenderingHandler)iSimpleBlockRenderingHandler);
            blockRenderers.put(string, bRBinding);
        }
        return bRBinding;
    }

    String qualifyName(String string) {
        return this.getClass().getPackage().getName() + "." + string;
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    void registerRenderers() {
    }

    void addBlockRenderer(BaseMod.IBlock iBlock, ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler) {
        this.addBlockRenderer(iSimpleBlockRenderingHandler, iBlock);
    }

    void addBlockRenderer(ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler, BaseMod.IBlock ... iBlockArray) {
        int n = RenderingRegistry.getNextAvailableRenderId();
        for (BaseMod.IBlock iBlock : iBlockArray) {
            System.out.printf("BaseModClient: Registering %s with id %s for %s\n", iSimpleBlockRenderingHandler, n, iBlock);
            iBlock.setRenderType(n);
            RenderingRegistry.registerBlockHandler((int)n, (ISimpleBlockRenderingHandler)iSimpleBlockRenderingHandler);
        }
    }

    void addItemRenderer(Item item, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)iItemRenderer);
    }

    void addItemRenderer(Block block, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((Item)block.func_149650_a(0, null, 0), (IItemRenderer)iItemRenderer);
    }

    void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre pre) {
        int n = pre.map.func_130086_a();
        System.out.printf("BaseModClient.onTextureStitchPre: for texture type %s\n", n);
        switch (n) {
            case 0: {
                this.registerBlockIcons((IIconRegister)pre.map);
                break;
            }
            case 1: {
                this.registerItemIcons((IIconRegister)pre.map);
            }
        }
    }

    void registerBlockIcons(IIconRegister iIconRegister) {
    }

    void registerItemIcons(IIconRegister iIconRegister) {
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        Class<? extends GuiScreen> clazz;
        int n5 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, n2, n3, n4, n5)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, n2, n3, n4, n5);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, n2, n3, n4, n5);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4, int n5) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    static class BRBinding
    extends IDBinding<ISimpleBlockRenderingHandler> {
        BRBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }
}

