/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseGui;

public class BaseGuiLayout {

    public static class Grid
    extends BaseGui.Group {
        public int rowSpacing = 4;
        public int colSpacing = 4;
        int numRows;
        int numCols;
        BaseGui.Widget[][] grid;

        public Grid(int n, Object ... objectArray) {
            this.numCols = n;
            this.numRows = (objectArray.length + n - 1) / n;
            this.grid = new BaseGui.Widget[this.numRows][n];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n2 = i / n;
                int n3 = i % n;
                BaseGui.Widget widget = null;
                if (object != null) {
                    widget = object instanceof String ? new Label((String)object) : (BaseGui.Widget)object;
                }
                this.grid[n2][n3] = widget;
                if (widget == null) continue;
                this.add(0, 0, widget);
            }
        }

        @Override
        public void layout() {
            int n;
            int n2;
            int n3;
            super.layout();
            int[] nArray = new int[this.numCols];
            int[] nArray2 = new int[this.numRows];
            for (n3 = 0; n3 < this.numRows; ++n3) {
                for (n2 = 0; n2 < this.numCols; ++n2) {
                    BaseGui.Widget widget = this.grid[n3][n2];
                    nArray2[n3] = Math.max(nArray2[n3], widget.height);
                    nArray[n2] = Math.max(nArray[n2], widget.width);
                }
            }
            n3 = 0;
            for (n2 = 0; n2 < this.numCols; ++n2) {
                if (n2 > 0) {
                    n3 += this.colSpacing;
                }
                int n4 = nArray[n2];
                for (n = 0; n < this.numRows; ++n) {
                    BaseGui.Widget widget = this.grid[n][n2];
                    if (widget == null) continue;
                    widget.left = n3;
                }
                n3 += n4;
            }
            this.width = n3;
            n2 = 0;
            for (int i = 0; i < this.numRows; ++i) {
                if (i > 0) {
                    n2 += this.rowSpacing;
                }
                n = nArray2[i];
                for (int j = 0; j < this.numCols; ++j) {
                    BaseGui.Widget widget = this.grid[i][j];
                    if (widget == null) continue;
                    widget.top = n2 + (n - widget.height) / 2;
                }
                n2 += n;
            }
            this.height = n2;
        }
    }

    public static class Label
    extends BaseGui.Widget {
        public String text;

        public Label(String string) {
            super(Label.stringWidth(string), 7);
            this.text = string;
        }

        @Override
        public void draw(BaseGui.Screen screen, int n, int n2) {
            screen.drawString(this.text, 0, 0);
        }
    }
}

