/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;

public class BaseGuiFields {

    public static class FloatField
    extends StringField {
        public double minValue = Double.MIN_VALUE;
        public double maxValue = Double.MAX_VALUE;

        public FloatField(int n, String string, BaseGui.Ref ref) {
            super(n, ref);
            this.format = string;
            this.charsAllowed = "0123456789.-eE";
        }

        @Override
        protected Object parseValue(String string) {
            double d = 0.0;
            if (string.length() > 0) {
                d = Double.parseDouble(string);
            }
            if (d < this.minValue) {
                d = this.minValue;
            }
            if (d > this.maxValue) {
                d = this.maxValue;
            }
            return new Double(d);
        }
    }

    public static class IntField
    extends StringField {
        public int minValue = Integer.MIN_VALUE;
        public int maxValue = Integer.MAX_VALUE;

        public IntField(int n, BaseGui.Ref ref) {
            super(n, ref);
            this.format = "%d";
            this.charsAllowed = "0123456789-";
        }

        @Override
        protected Object parseValue(String string) {
            int n = 0;
            if (string.length() > 0) {
                n = Integer.parseInt(string);
            }
            if (n < this.minValue) {
                n = this.minValue;
            }
            if (n > this.maxValue) {
                n = this.maxValue;
            }
            return new Integer(n);
        }
    }

    public static class StringField
    extends BaseGui.Widget {
        public int left;
        public int top;
        public Object targeObject;
        public BaseGui.Ref target;
        public String format;
        public String charsAllowed;
        protected GuiTextField base;
        protected BaseGui.IWidgetContainer parent;
        protected boolean isOpen;

        public StringField(int n, BaseGui.Ref ref) {
            this((n + 1) * 6, 12, ref);
        }

        public StringField(int n, int n2, BaseGui.Ref ref) {
            super(n, n2);
            this.base = new GuiTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, n, n2);
            this.target = ref;
        }

        @Override
        public void draw(BaseGui.Screen screen, int n, int n2) {
            if (!this.isOpen) {
                this.load();
            }
            this.base.func_146194_f();
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords mouseCoords, int n) {
            this.open();
            this.base.func_146192_a(mouseCoords.x, mouseCoords.y, n);
        }

        @Override
        public boolean keyPressed(char c, int n) {
            if (n == 1) {
                this.close();
                return false;
            }
            if (c == '\r') {
                this.close();
                return true;
            }
            if (c < ' ' || c == '\u007f' || n == 14 || n == 199 || n == 203 || n == 205 || n == 207 || n == 211 || this.charAllowed(c)) {
                this.open();
                this.base.func_146201_a(c, n);
                return true;
            }
            return false;
        }

        protected boolean charAllowed(char c) {
            return this.charsAllowed == null || this.charsAllowed.indexOf(c) >= 0;
        }

        @Override
        public void focusChanged(boolean bl) {
            if (bl) {
                this.open();
            } else {
                this.close();
            }
            this.base.func_146195_b(bl);
        }

        protected void open() {
            if (!this.isOpen) {
                this.isOpen = true;
                this.load();
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.save();
                this.isOpen = false;
            }
        }

        protected void load() {
            this.base.func_146180_a(this.formatValue(this.target.get()));
        }

        protected void save() {
            try {
                this.target.set(this.parseValue(this.base.func_146179_b()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.load();
            }
        }

        protected String formatValue(Object object) {
            if (this.format != null) {
                return String.format(this.format, object);
            }
            return (String)object;
        }

        protected Object parseValue(String string) {
            return string;
        }
    }
}

