/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseColorUtils;
import gcewing.projectblue.BaseGui;

public class BaseGuiColor {
    public static int colorForIndex(int n) {
        return BaseColorUtils.colors[n];
    }

    public static class ColorChooser
    extends BaseGui.Widget {
        protected static final int cellSize = 10;
        protected BaseGui.Ref target;

        public ColorChooser(BaseGui.Ref ref) {
            super(48, 58);
            this.target = ref;
        }

        @Override
        public void draw(BaseGui.Screen screen, int n, int n2) {
            int n3 = (Integer)this.target.get();
            if (n3 < 0) {
                n3 = 16;
            }
            screen.drawGuiBackground(0.0, 0.0, this.width, this.height);
            for (int i = 0; i <= 16; ++i) {
                int n4 = 4 + (i & 3) * 10;
                int n5 = 4 + (i >> 2) * 10;
                if (i == n3) {
                    screen.setColor(0x808080);
                    screen.drawRect(n4, n5, 10.0, 10.0);
                }
                int n6 = i <= 15 ? BaseGuiColor.colorForIndex(i) : 0xA0A0A0;
                screen.setColor(n6);
                screen.drawRect(n4 + 1, n5 + 1, 8.0, 8.0);
                if (i != 16) continue;
                screen.drawCenteredString("x", n4 + 5, n5 + 1);
            }
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords mouseCoords, int n) {
            int n2;
            if (mouseCoords.x < 0 || mouseCoords.x >= this.width() || mouseCoords.y < 0 || mouseCoords.y >= this.height()) {
                this.close();
                return;
            }
            int n3 = (mouseCoords.x - 4) / 10;
            int n4 = (mouseCoords.y - 4) / 10;
            if (n4 >= 0 && n4 < 5 && n3 >= 0 && n3 < 4 && (n2 = n4 * 4 + n3) <= 16) {
                if (n2 > 15) {
                    n2 = -1;
                }
                this.target.set(n2);
                this.close();
            }
        }

        @Override
        public boolean keyPressed(char c, int n) {
            if (n == 1) {
                this.close();
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            this.removePopup();
        }
    }

    public static class ColorField
    extends BaseGui.Widget {
        protected BaseGui.Ref target;

        public ColorField(BaseGui.Ref ref) {
            super(8, 8);
            this.target = ref;
        }

        @Override
        public void draw(BaseGui.Screen screen, int n, int n2) {
            screen.setColor(0x606060);
            screen.drawRect(-1.0, -1.0, this.width + 2, this.height + 2);
            int n3 = (Integer)this.target.get();
            if (n3 >= 0) {
                screen.setColor(BaseGuiColor.colorForIndex(n3));
                screen.drawRect(0.0, 0.0, this.width, this.height);
            } else {
                screen.setColor(0x808080);
                screen.drawRect(0.0, 0.0, this.width, this.height);
                screen.drawCenteredString("x", this.width / 2, 0);
            }
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords mouseCoords, int n) {
            ColorChooser colorChooser = new ColorChooser(this.target);
            this.addPopup(this.width + 2, -1, colorChooser);
        }
    }
}

