/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue.mfr;

import gcewing.projectblue.BaseColorUtils;
import gcewing.projectblue.BaseDataChannel;
import gcewing.projectblue.BaseGuiContainer;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.mfr.RednetAdaptorContainer;
import gcewing.projectblue.mfr.RednetAdaptorTE;

public class RednetAdaptorGui
extends BaseGuiContainer {
    static final int guiWidth = 216;
    static final int guiHeight = 84;
    static final int wireLeft = 12;
    static final int wireTop = 30;
    static final int wireWidth = 10;
    static final int wireHeight = 26;
    static final int wireSpacing = 12;
    RednetAdaptorTE te;

    public RednetAdaptorGui(RednetAdaptorContainer container) {
        super(container, 216, 84);
        this.te = container.te;
    }

    @Override
    protected void drawBackgroundLayer() {
        this.bindTexture("gui/gui_rednet_adaptor.png", 256, 128);
        this.drawTexturedRect(0.0, 0.0, 216.0, 84.0, 0.0, 0.0);
        for (int i = 0; i < 16; ++i) {
            int c = BaseColorUtils.colors[i];
            this.setColor(c);
            int wireX = 12 + 12 * i;
            int wireY = 30;
            int wireU = 216;
            boolean wireV = false;
            int arrowU = 216;
            int arrowV = 52;
            boolean showArrow = true;
            switch (this.te.signalConfig[i]) {
                case 2: {
                    break;
                }
                case 3: {
                    arrowV += 8;
                    break;
                }
                default: {
                    wireU += 20;
                    showArrow = false;
                }
            }
            this.drawTexturedRect(wireX, wireY, 10.0, 26.0, wireU, (double)wireV, 20.0, 52.0);
            this.setColor(1.0, 1.0, 1.0);
            if (showArrow) {
                this.drawTexturedRect(wireX, wireY + 11, 10.0, 4.0, arrowU, arrowV, 20.0, 8.0);
                continue;
            }
            this.drawTexturedRect(wireX, wireY + 8, 10.0, 2.0, 216.0, 68.0, 20.0, 4.0);
        }
        this.drawCenteredString("Bundled Cable", 108, 6);
        this.drawCenteredString("RedNet", 108, 71);
    }

    protected void func_73864_a(int sx, int sy, int button) {
        int i;
        int x = sx - this.field_147003_i;
        int y = sy - this.field_147009_r;
        if (x > 12 && y > 30 && y < 56 && (i = (x - 12) / 12) < 16) {
            BaseDataChannel.ChannelOutput out = ProjectBlue.dataChannel.openServerContainer("toggleConfig");
            out.writeInt(i);
            out.writeInt(button);
            out.close();
        }
    }
}

