/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.BlockPamChurn;
import com.pam.harvestcraft.ChurnRecipes;
import com.pam.harvestcraft.ItemRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityChurn
extends TileEntity
implements ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    public int churnBurnTime;
    public int currentItemBurnTime;
    public int churnCookTime;
    private ItemStack[] churnItemStacks = new ItemStack[3];
    private String field_145958_o;

    public static int getItemBurnTime(ItemStack p_145952_0_) {
        if (p_145952_0_ == null) {
            return 0;
        }
        Item item = p_145952_0_.func_77973_b();
        if (item == ItemRegistry.saltItem) {
            return 1600;
        }
        return GameRegistry.getFuelValue((ItemStack)p_145952_0_);
    }

    public static boolean isItemFuel(ItemStack p_145954_0_) {
        return TileEntityChurn.getItemBurnTime(p_145954_0_) > 0;
    }

    public int func_70302_i_() {
        return this.churnItemStacks.length;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.churnItemStacks[p_70301_1_];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.churnItemStacks[p_70298_1_] != null) {
            if (this.churnItemStacks[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.churnItemStacks[p_70298_1_];
                this.churnItemStacks[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.churnItemStacks[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.churnItemStacks[p_70298_1_].field_77994_a == 0) {
                this.churnItemStacks[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.churnItemStacks[p_70304_1_] != null) {
            ItemStack itemstack = this.churnItemStacks[p_70304_1_];
            this.churnItemStacks[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.churnItemStacks[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.field_145958_o : "Churn";
    }

    public boolean func_145818_k_() {
        return this.field_145958_o != null && this.field_145958_o.length() > 0;
    }

    public void func_145951_a(String p_145951_1_) {
        this.field_145958_o = p_145951_1_;
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        NBTTagList nbttaglist = p_145839_1_.func_150295_c("Items", 10);
        this.churnItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.churnItemStacks.length) continue;
            this.churnItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.churnBurnTime = p_145839_1_.func_74765_d("BurnTime");
        this.churnCookTime = p_145839_1_.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityChurn.getItemBurnTime(this.churnItemStacks[1]);
        if (p_145839_1_.func_150297_b("CustomName", 8)) {
            this.field_145958_o = p_145839_1_.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound p_145841_1_) {
        super.func_145841_b(p_145841_1_);
        p_145841_1_.func_74777_a("BurnTime", (short)this.churnBurnTime);
        p_145841_1_.func_74777_a("CookTime", (short)this.churnCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.churnItemStacks.length; ++i) {
            if (this.churnItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.churnItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        p_145841_1_.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            p_145841_1_.func_74778_a("CustomName", this.field_145958_o);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int p_145953_1_) {
        return this.churnCookTime * p_145953_1_ / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.churnBurnTime * p_145955_1_ / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.churnBurnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.churnBurnTime > 0;
        boolean flag1 = false;
        if (this.churnBurnTime > 0) {
            --this.churnBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.churnBurnTime != 0 || this.churnItemStacks[1] != null && this.churnItemStacks[0] != null) {
                if (this.churnBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.churnBurnTime = TileEntityChurn.getItemBurnTime(this.churnItemStacks[1]);
                    if (this.churnBurnTime > 0) {
                        flag1 = true;
                        if (this.churnItemStacks[1] != null) {
                            --this.churnItemStacks[1].field_77994_a;
                            if (this.churnItemStacks[1].field_77994_a == 0) {
                                this.churnItemStacks[1] = this.churnItemStacks[1].func_77973_b().getContainerItem(this.churnItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.churnCookTime;
                    if (this.churnCookTime == 200) {
                        this.churnCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.churnCookTime = 0;
                }
            }
            if (flag != this.churnBurnTime > 0) {
                flag1 = true;
                BlockPamChurn.updateChurnBlockState(this.churnBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.churnItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = ChurnRecipes.smelting().getSmeltingResult(this.churnItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.churnItemStacks[2] == null) {
            return true;
        }
        if (!this.churnItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.churnItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.churnItemStacks[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ChurnRecipes.smelting().getSmeltingResult(this.churnItemStacks[0]);
            if (this.churnItemStacks[2] == null) {
                this.churnItemStacks[2] = itemstack.func_77946_l();
            } else if (this.churnItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.churnItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.churnItemStacks[0].field_77994_a;
            if (this.churnItemStacks[0].field_77994_a <= 0) {
                this.churnItemStacks[0] = null;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return p_94041_1_ != 2 && (p_94041_1_ != 1 || TileEntityChurn.isItemFuel(p_94041_2_));
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slotsBottom : (p_94128_1_ == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.func_94041_b(p_102007_1_, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_3_ != 0 || p_102008_1_ != 1 || p_102008_2_.func_77973_b() == Items.field_151133_ar;
    }
}

