/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.gui.widgets.movable;

import mcp.mobius.opis.gui.events.MouseEvent;
import mcp.mobius.opis.gui.helpers.UIHelper;
import mcp.mobius.opis.gui.interfaces.IWidget;
import mcp.mobius.opis.gui.interfaces.Signal;
import mcp.mobius.opis.gui.widgets.WidgetBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class PictureMovableRC
extends WidgetBase {
    private double offsetX;
    private double offsetY;
    protected ResourceLocation texture;

    public PictureMovableRC(IWidget parent, String uri) {
        super(parent);
        this.texture = new ResourceLocation(uri);
    }

    @Override
    public void onMouseClick(MouseEvent event) {
        this.offsetX = event.x - (double)this.geom.getUnalignedPos(this.parent).getX();
        this.offsetY = event.y - (double)this.geom.getUnalignedPos(this.parent).getY();
    }

    @Override
    public void onMouseDrag(MouseEvent event) {
        double newX = event.x - this.offsetX;
        double newY = event.y - this.offsetY;
        newX = Math.max(newX, (double)this.parent.getLeft());
        newY = Math.max(newY, (double)this.parent.getTop());
        newX = Math.min(newX, (double)this.parent.getRight());
        newY = Math.min(newY, (double)this.parent.getBottom());
        this.setPos((newX - (double)this.parent.getLeft()) / (double)this.parent.getSize().getX() * 100.0, (newY - (double)this.parent.getTop()) / (double)this.parent.getSize().getY() * 100.0);
        this.emit(Signal.DRAGGED, this.getPos());
    }

    @Override
    public void draw(Point pos) {
        this.saveGLState();
        GL11.glPushMatrix();
        this.texManager.func_110577_a(this.texture);
        UIHelper.drawTexture(pos.getX(), pos.getY(), this.getSize().getX(), this.getSize().getY());
        GL11.glPopMatrix();
        this.loadGLState();
    }
}

