/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.rcon.server;

import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.rcon.server.RConHandshakeDecoder;
import mcp.mobius.opis.network.rcon.server.RConHandshakeHandler;
import mcp.mobius.shadow.io.nettyopis.bootstrap.ServerBootstrap;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFuture;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelInitializer;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelOption;
import mcp.mobius.shadow.io.nettyopis.channel.nio.NioEventLoopGroup;
import mcp.mobius.shadow.io.nettyopis.channel.socket.SocketChannel;
import mcp.mobius.shadow.io.nettyopis.channel.socket.nio.NioServerSocketChannel;
import mcp.mobius.shadow.io.nettyopis.handler.ssl.SslContext;
import mcp.mobius.shadow.io.nettyopis.handler.ssl.util.SelfSignedCertificate;
import mcp.mobius.shadow.io.nettyopis.handler.timeout.ReadTimeoutHandler;

public class RConServer
implements Runnable {
    public static final RConServer instance = new RConServer();
    private int port = modOpis.rconport;

    private RConServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!modOpis.rconactive) {
            return;
        }
        modOpis.log.info("Starting Opis remote control server.");
        SelfSignedCertificate ssc = null;
        SslContext sslCtx = null;
        try {
            ssc = new SelfSignedCertificate();
            sslCtx = SslContext.newServerContext(ssc.certificate(), ssc.privateKey());
        }
        catch (CertificateException e1) {
            e1.printStackTrace();
        }
        catch (SSLException e1) {
            e1.printStackTrace();
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInit(sslCtx)).option(ChannelOption.SO_BACKLOG, 128)).childOption(ChannelOption.SO_KEEPALIVE, true);
            ChannelFuture f = b.bind(this.port).sync();
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            modOpis.log.error("Error in Opis remote control server.");
            e.printStackTrace();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    class ChannelInit
    extends ChannelInitializer<SocketChannel> {
        private final SslContext sslCtx;

        public ChannelInit(SslContext sslCtx) {
            this.sslCtx = sslCtx;
        }

        @Override
        protected void initChannel(SocketChannel ch) throws Exception {
            ch.pipeline().addLast(this.sslCtx.newHandler(ch.alloc()));
            ch.pipeline().addLast(new ReadTimeoutHandler(10));
            ch.pipeline().addLast(new RConHandshakeDecoder());
            ch.pipeline().addLast(new RConHandshakeHandler());
        }
    }
}

