/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.channel.embedded;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import mcp.mobius.shadow.io.nettyopis.channel.AbstractChannel;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelConfig;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFuture;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandler;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelInboundHandlerAdapter;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelMetadata;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelOutboundBuffer;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelPipeline;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelPromise;
import mcp.mobius.shadow.io.nettyopis.channel.DefaultChannelConfig;
import mcp.mobius.shadow.io.nettyopis.channel.EventLoop;
import mcp.mobius.shadow.io.nettyopis.channel.embedded.EmbeddedEventLoop;
import mcp.mobius.shadow.io.nettyopis.channel.embedded.EmbeddedSocketAddress;
import mcp.mobius.shadow.io.nettyopis.util.ReferenceCountUtil;
import mcp.mobius.shadow.io.nettyopis.util.internal.PlatformDependent;
import mcp.mobius.shadow.io.nettyopis.util.internal.RecyclableArrayList;
import mcp.mobius.shadow.io.nettyopis.util.internal.logging.InternalLogger;
import mcp.mobius.shadow.io.nettyopis.util.internal.logging.InternalLoggerFactory;

public class EmbeddedChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();
    private final Queue<Object> inboundMessages = new ArrayDeque<Object>();
    private final Queue<Object> outboundMessages = new ArrayDeque<Object>();
    private Throwable lastException;
    private int state;

    public EmbeddedChannel(ChannelHandler ... handlers) {
        super(null);
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        int nHandlers = 0;
        ChannelPipeline p = this.pipeline();
        for (ChannelHandler h : handlers) {
            if (h == null) break;
            ++nHandlers;
            p.addLast(h);
        }
        if (nHandlers == 0) {
            throw new IllegalArgumentException("handlers is empty.");
        }
        this.loop.register(this);
        p.addLast(new LastInboundHandler());
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    public Queue<Object> inboundMessages() {
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public Object readInbound() {
        return this.inboundMessages.poll();
    }

    public Object readOutbound() {
        return this.outboundMessages.poll();
    }

    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return !this.inboundMessages.isEmpty();
        }
        ChannelPipeline p = this.pipeline();
        for (Object m : msgs) {
            p.fireChannelRead(m);
        }
        p.fireChannelReadComplete();
        this.runPendingTasks();
        this.checkException();
        return !this.inboundMessages.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return !this.outboundMessages.isEmpty();
        }
        RecyclableArrayList futures = RecyclableArrayList.newInstance(msgs.length);
        try {
            for (Object m : msgs) {
                if (m == null) break;
                futures.add(this.write(m));
            }
            this.flush();
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ChannelFuture future = (ChannelFuture)futures.get(i);
                assert (future.isDone());
                if (future.cause() == null) continue;
                this.recordException(future.cause());
            }
            this.runPendingTasks();
            this.checkException();
            boolean bl = !this.outboundMessages.isEmpty();
            return bl;
        }
        finally {
            futures.recycle();
        }
    }

    public boolean finish() {
        this.close();
        this.runPendingTasks();
        this.checkException();
        return !this.inboundMessages.isEmpty() || !this.outboundMessages.isEmpty();
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    public void checkException() {
        Throwable t = this.lastException;
        if (t == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(t);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? this.localAddress : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? this.remoteAddress : null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = 1;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.state = 2;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            ReferenceCountUtil.retain(msg);
            this.outboundMessages.add(msg);
            in.remove();
        }
    }

    private final class LastInboundHandler
    extends ChannelInboundHandlerAdapter {
        private LastInboundHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            EmbeddedChannel.this.inboundMessages.add(msg);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            EmbeddedChannel.this.recordException(cause);
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
            super(EmbeddedChannel.this);
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }
}

