/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingserver;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataEvent;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import mcp.mobius.shadow.net.miginfocom.swing.MigLayout;

public class PanelTimingHandlers
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRun;
    private JLabel lblSummary;

    public PanelTimingHandlers() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 1 0");
        this.btnRun.addActionListener(new ActionRunOpis());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.table = new JTableStats(new String[]{"Mod", "Tick", "Update Time"}, new Class[]{CachedString.class, String.class, DataTiming.class});
        scrollPane.setViewportView(this.table);
        this.lblSummary = new JLabel("TmpText");
        this.add((Component)this.lblSummary, "cell 0 2 2 1,alignx center");
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    public JLabel getLblSummary() {
        return this.lblSummary;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_HANDLERS: {
                this.cacheData(msg, rawdata);
                SwingUtilities.invokeLater(() -> {
                    this.getTable().setTableData(rawdata.array);
                    DefaultTableModel model = this.table.getModel();
                    int row = this.getTable().clearTable(DataEvent.class);
                    for (ISerializable o : rawdata.array) {
                        DataEvent data = (DataEvent)o;
                        try {
                            model.addRow(new Object[]{data.mod, data.event.toString().split("\\$")[1], data.update});
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            model.addRow(new Object[]{data.mod, data.event.toString(), data.update});
                        }
                    }
                    this.getTable().dataUpdated(row);
                });
                break;
            }
            case VALUE_TIMING_HANDLERS: {
                SwingUtilities.invokeLater(() -> this.getLblSummary().setText(String.format("Total update time : %s", rawdata.value.toString())));
                break;
            }
            case STATUS_START: 
            case STATUS_RUNNING: {
                SwingUtilities.invokeLater(() -> this.getBtnRun().setText("Running..."));
                break;
            }
            case STATUS_STOP: {
                SwingUtilities.invokeLater(() -> this.getBtnRun().setText("Run Opis"));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.TIMINGHANDLERS;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

